/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.loginimpl;

import com.hazelcast.config.security.LdapSearchScope;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.security.impl.LdapUtils;
import com.hazelcast.security.impl.SecurityUtil;
import com.hazelcast.security.loginimpl.BasicLdapLoginModule;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class LdapLoginModule
extends BasicLdapLoginModule {
    public static final String PLACEHOLDER_LOGIN = "{login}";
    public static final String OPTION_USER_CONTEXT = "userContext";
    public static final String OPTION_USER_FILTER = "userFilter";
    public static final String OPTION_USER_SEARCH_SCOPE = "userSearchScope";
    public static final String OPTION_PASSWORD_ATTRIBUTE = "passwordAttribute";
    public static final String OPTION_SKIP_AUTHENTICATION = "skipAuthentication";
    public static final String OPTION_SECURITY_REALM = "securityRealm";
    public static final String DEFAULT_USER_FILTER = "(uid={login})";
    private LdapSearchScope userSearchScope;
    private String userContext;
    private String userFilter;
    private String passwordAttribute;
    private boolean skipAuthentication;

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.userSearchScope = this.getSearchScope(OPTION_USER_SEARCH_SCOPE);
        this.userContext = this.getStringOption(OPTION_USER_CONTEXT, "");
        this.userFilter = this.getStringOption(OPTION_USER_FILTER, DEFAULT_USER_FILTER);
        this.passwordAttribute = this.getStringOption(OPTION_PASSWORD_ATTRIBUTE, null);
        this.skipAuthentication = this.getBoolOption(OPTION_SKIP_AUTHENTICATION, false);
    }

    @Override
    protected boolean onLogin() throws LoginException {
        Subject subject = SecurityUtil.getRunAsSubject(this.callbackHandler, this.getStringOption(OPTION_SECURITY_REALM, null));
        if (subject != null) {
            try {
                return Subject.doAs(subject, () -> super.onLogin());
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof LoginException) {
                    throw (LoginException)e.getCause();
                }
                LoginException loginException = new LoginException("PrivilegedAction execution failed");
                loginException.initCause(e.getCause());
                throw loginException;
            }
        }
        return super.onLogin();
    }

    @Override
    protected Attributes setUserDnAndGetAttributes() throws NamingException, FailedLoginException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(this.userSearchScope.toSearchControlValue());
        SearchResult userSearchResult = null;
        String filter = LdapUtils.replacePlaceholders(this.userFilter, PLACEHOLDER_LOGIN, this.login);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Searching a user object in LDAP server. Filter: " + filter);
        }
        NamingEnumeration<SearchResult> namingEnum = this.ctx.search(this.userContext, filter, searchControls);
        boolean isRelative = false;
        while (this.hasMoreIgnorePartResEx(namingEnum) && !isRelative) {
            userSearchResult = namingEnum.next();
            isRelative = userSearchResult.isRelative();
        }
        if (userSearchResult == null || !isRelative) {
            throw new FailedLoginException("User not found");
        }
        this.userDN = userSearchResult.getName();
        if (!StringUtil.isNullOrEmpty(this.userContext)) {
            this.userDN = this.userDN + "," + this.userContext;
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Matching user object was found. DN: " + this.userDN);
        }
        this.userAttributes = userSearchResult.getAttributes();
        if (!this.skipAuthentication) {
            this.verifyPassword();
        }
        return userSearchResult.getAttributes();
    }

    private void verifyPassword() throws FailedLoginException, NamingException {
        if (this.passwordAttribute == null) {
            this.logger.fine("Verifying user credentials by doing a new LDAP bind.");
            this.authenticateByNewBind(this.userDN, this.password);
        } else {
            String passwordInLdap;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Verifying user credentials by comparing provided password against LDAP attribute " + this.passwordAttribute);
            }
            if ((passwordInLdap = LdapUtils.getAttributeValue(this.userAttributes, this.passwordAttribute)) == null || !passwordInLdap.equals(this.password)) {
                throw new FailedLoginException("Provided password doesn't match the expected value.");
            }
        }
    }

    @Override
    protected void initAuthentication() throws FailedLoginException {
        if (this.skipAuthentication) {
            this.login = this.getLastIdentity();
        } else {
            super.initAuthentication();
        }
    }

    @Override
    protected LdapContext createLdapContext() throws NamingException {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.referral", "ignore");
        env.put("java.naming.security.authentication", "simple");
        env.putAll((Map<?, ?>)this.options);
        this.logLdapContextProperties(env);
        return new InitialLdapContext(env, null);
    }

    private void authenticateByNewBind(String principalDn, String password) throws FailedLoginException {
        if (StringUtil.isNullOrEmpty(principalDn) || StringUtil.isNullOrEmpty(password)) {
            throw new FailedLoginException("Anonymous bind is not allowed");
        }
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.putAll((Map<?, ?>)this.options);
        env.setProperty("java.naming.security.authentication", "simple");
        env.setProperty("java.naming.security.principal", principalDn);
        env.setProperty("java.naming.security.credentials", password);
        try {
            this.logLdapContextProperties(env);
            new InitialLdapContext(env, null).close();
        }
        catch (NamingException e) {
            this.logger.finest(e);
            throw new FailedLoginException("User authentication by LDAP bind failed");
        }
    }
}

