/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.JavaKeyStoreSecureStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecureStoreConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.SecretStrengthPolicy;
import com.hazelcast.security.WeakSecretException;
import com.hazelcast.security.impl.WeakSecretError;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class WeakSecretsConfigChecker {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final Config config;
    private final SecretStrengthPolicy policy;

    public WeakSecretsConfigChecker(Config config) {
        this.config = config;
        SecretStrengthPolicy policy = null;
        try {
            policy = (SecretStrengthPolicy)ClassLoaderUtil.newInstance(WeakSecretsConfigChecker.class.getClassLoader(), System.getProperty("hazelcast.security.secret.strength.policy.class", "com.hazelcast.security.impl.DefaultSecretStrengthPolicy"));
        }
        catch (Exception e) {
            ExceptionUtil.rethrow(e);
        }
        this.policy = policy;
    }

    public void evaluateAndReport(ILogger logger) {
        Map<String, EnumSet<WeakSecretError>> report = this.evaluate();
        if (!report.isEmpty()) {
            logger.warning(this.constructBanner(report));
            if (WeakSecretException.ENFORCED) {
                throw new WeakSecretException("Weak secrets found in configuration, check output above for more details.");
            }
        }
    }

    public Map<String, EnumSet<WeakSecretError>> evaluate() {
        SSLConfig sslConfig;
        HotRestartPersistenceConfig hotRestartPersistenceConfig;
        SymmetricEncryptionConfig sec;
        HashMap<String, EnumSet<WeakSecretError>> result = new HashMap<String, EnumSet<WeakSecretError>>();
        SecurityConfig securityConfig = this.config.getSecurityConfig();
        if (securityConfig != null && securityConfig.isEnabled()) {
            this.checkRealmsPasswords(result, securityConfig.getRealmConfigs());
        }
        if ((sec = ConfigAccessor.getActiveMemberNetworkConfig(this.config).getSymmetricEncryptionConfig()) != null && sec.isEnabled()) {
            this.checkSymmetricEncryptionPasswords(result, sec);
        }
        if ((hotRestartPersistenceConfig = this.config.getHotRestartPersistenceConfig()) != null && hotRestartPersistenceConfig.isEnabled()) {
            this.checkHotRestartPasswords(result, hotRestartPersistenceConfig);
        }
        if ((sslConfig = ConfigAccessor.getActiveMemberNetworkConfig(this.config).getSSLConfig()) != null && sslConfig.isEnabled() && sslConfig.getProperties() != null && !sslConfig.getProperties().isEmpty()) {
            this.checkSSLConfigPasswords(result, sslConfig);
        }
        return result;
    }

    private void checkSSLConfigPasswords(Map<String, EnumSet<WeakSecretError>> result, SSLConfig sslConfig) {
        Properties props = sslConfig.getProperties();
        for (Object key : props.keySet()) {
            if (!((String)key).toLowerCase(Locale.US).contains("password")) continue;
            result.put("SSLConfig property[" + key + "]", this.getWeaknesses(props.getProperty((String)key)));
        }
    }

    private void checkHotRestartPasswords(Map<String, EnumSet<WeakSecretError>> result, HotRestartPersistenceConfig hotRestartPersistenceConfig) {
        Map<String, String> hotRestartSecrets = WeakSecretsConfigChecker.getHotRestartSecrets(hotRestartPersistenceConfig);
        for (Map.Entry<String, String> entry : hotRestartSecrets.entrySet()) {
            EnumSet<WeakSecretError> weaknesses = this.getWeaknesses(entry.getValue());
            if (weaknesses.isEmpty()) continue;
            result.put(entry.getKey(), weaknesses);
        }
    }

    private void checkSymmetricEncryptionPasswords(Map<String, EnumSet<WeakSecretError>> result, SymmetricEncryptionConfig sec) {
        EnumSet<WeakSecretError> symEncSaltWeaknesses;
        EnumSet<WeakSecretError> symEncPwdWeaknesses = this.getWeaknesses(sec.getPassword());
        if (!symEncPwdWeaknesses.isEmpty()) {
            result.put("Symmetric Encryption Password", symEncPwdWeaknesses);
        }
        if (!(symEncSaltWeaknesses = this.getWeaknesses(sec.getSalt())).isEmpty()) {
            result.put("Symmetric Encryption Salt", symEncSaltWeaknesses);
        }
    }

    private static Map<String, String> getHotRestartSecrets(HotRestartPersistenceConfig hotRestartPersistenceConfig) {
        JavaKeyStoreSecureStoreConfig javaKeyStoreSecureStoreConfig;
        String javaKeyStorePassword;
        SecureStoreConfig secureStoreConfig;
        EncryptionAtRestConfig encryptionAtRestConfig;
        HashMap<String, String> secrets = new HashMap<String, String>();
        if (hotRestartPersistenceConfig.isEnabled() && (encryptionAtRestConfig = hotRestartPersistenceConfig.getEncryptionAtRestConfig()).isEnabled() && (secureStoreConfig = encryptionAtRestConfig.getSecureStoreConfig()) instanceof JavaKeyStoreSecureStoreConfig && (javaKeyStorePassword = (javaKeyStoreSecureStoreConfig = (JavaKeyStoreSecureStoreConfig)secureStoreConfig).getPassword()) != null) {
            secrets.put("Hot Restart Encryption Java KeyStore password", javaKeyStorePassword);
        }
        return secrets;
    }

    private void checkRealmsPasswords(Map<String, EnumSet<WeakSecretError>> result, Map<String, RealmConfig> realms) {
        if (realms == null) {
            return;
        }
        for (Map.Entry<String, RealmConfig> entry : realms.entrySet()) {
            EnumSet<WeakSecretError> pwdWeaknesses;
            UsernamePasswordIdentityConfig identityCfg = entry.getValue().getUsernamePasswordIdentityConfig();
            if (identityCfg == null || !(pwdWeaknesses = this.getWeaknesses(identityCfg.getPassword())).isEmpty()) continue;
            result.put("Identity password in Security realm " + entry.getKey(), pwdWeaknesses);
        }
    }

    private EnumSet<WeakSecretError> getWeaknesses(String secret) {
        try {
            this.policy.validate(null, secret);
        }
        catch (WeakSecretException ex) {
            return ex.getWeaknesses();
        }
        return EnumSet.noneOf(WeakSecretError.class);
    }

    private String constructBanner(Map<String, EnumSet<WeakSecretError>> report) {
        StringBuilder banner = new StringBuilder();
        banner.append(LINE_SEP).append("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ SECURITY WARNING @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@").append(LINE_SEP);
        for (Map.Entry<String, EnumSet<WeakSecretError>> weakSecret : report.entrySet()) {
            banner.append(WeakSecretException.formatMessage(weakSecret.getKey(), weakSecret.getValue())).append(LINE_SEP).append(LINE_SEP);
        }
        banner.append("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        return banner.toString();
    }
}

