/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.ClientService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Endpoint;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.event.CPGroupAvailabilityListener;
import com.hazelcast.cp.event.CPMembershipListener;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.cp.session.CPSessionManagementService;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.jet.JetService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.security.SecureCallable;
import com.hazelcast.security.impl.SecurityContextImpl;
import com.hazelcast.security.impl.SecurityDataSerializerHook;
import com.hazelcast.security.permission.AtomicLongPermission;
import com.hazelcast.security.permission.AtomicReferencePermission;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.security.permission.CardinalityEstimatorPermission;
import com.hazelcast.security.permission.CountDownLatchPermission;
import com.hazelcast.security.permission.FlakeIdGeneratorPermission;
import com.hazelcast.security.permission.ListPermission;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.security.permission.PNCounterPermission;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.security.permission.SemaphorePermission;
import com.hazelcast.security.permission.SetPermission;
import com.hazelcast.security.permission.TopicPermission;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.SqlServiceImpl;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="we implement IdentifiedDataSerializable, so Serializable is not used")
public final class SecureCallableImpl<V>
implements SecureCallable<V>,
IdentifiedDataSerializable {
    private Map<String, Map<String, String>> serviceToMethod;
    private Subject subject;
    private Object taskObject;
    private boolean blockUnmappedActions;
    private transient Node node;

    public SecureCallableImpl() {
    }

    public SecureCallableImpl(Subject subject, Callable<V> taskObject, Map<String, Map<String, String>> serviceToMethod) {
        this.subject = subject;
        this.taskObject = taskObject;
        this.serviceToMethod = serviceToMethod;
    }

    public SecureCallableImpl(Subject subject, Runnable runnable, Map<String, Map<String, String>> serviceToMethod) {
        this.subject = subject;
        this.taskObject = runnable;
        this.serviceToMethod = serviceToMethod;
    }

    @Override
    public V call() throws Exception {
        if (this.taskObject instanceof Runnable) {
            ((Runnable)this.taskObject).run();
            return null;
        }
        return ((Callable)this.taskObject).call();
    }

    public String toString() {
        return "SecureCallable [subject=" + this.subject + ", taskObject=" + this.taskObject + "]";
    }

    @Override
    public int getFactoryId() {
        return SecurityDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.taskObject);
        boolean hasSubject = this.subject != null;
        out.writeBoolean(hasSubject);
        if (hasSubject) {
            Set<Principal> principals = this.subject.getPrincipals();
            out.writeInt(principals.size());
            for (Principal principal : principals) {
                out.writeObject(principal);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.taskObject = in.readObject();
        boolean hasSubject = in.readBoolean();
        if (hasSubject) {
            this.subject = new Subject();
            int size = in.readInt();
            Set<Principal> principals = this.subject.getPrincipals();
            for (int i = 0; i < size; ++i) {
                Principal principal = (Principal)in.readObject();
                principals.add(principal);
            }
        }
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        if (this.taskObject instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)this.taskObject).setHazelcastInstance(new HazelcastInstanceDelegate(hazelcastInstance));
        }
    }

    @Override
    public void setNode(Node node) {
        this.node = node;
        this.blockUnmappedActions = node.getConfig().getSecurityConfig().getClientBlockUnmappedActions();
        this.serviceToMethod = ((SecurityContextImpl)node.getNodeExtension().getSecurityContext()).getServiceToMethod();
    }

    private <T> T getProxy(SecureInvocationHandler handler) {
        DistributedObject distributedObject = handler.getDistributedObject();
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), SecureCallableImpl.getAllInterfaces(distributedObject), (InvocationHandler)handler);
        return (T)proxy;
    }

    private void checkPermission(Permission permission) {
        this.node.securityContext.checkPermission(this.subject, permission);
    }

    private static Class[] getAllInterfaces(Object instance) {
        HashSet all = new HashSet();
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Collections.addAll(all, clazz.getInterfaces());
        }
        return all.toArray(new Class[0]);
    }

    private class SqlServiceDelegate
    implements SqlService {
        private final SqlServiceImpl sqlService;
        private final SqlSecurityContext sqlSecurityContext;

        SqlServiceDelegate(SqlServiceImpl sqlService, SqlSecurityContext sqlSecurityContext) {
            this.sqlService = sqlService;
            this.sqlSecurityContext = sqlSecurityContext;
        }

        @Override
        @Nonnull
        public SqlResult execute(@Nonnull String sql, Object ... params) {
            SqlStatement statement = new SqlStatement(sql);
            if (params != null) {
                for (Object param : params) {
                    statement.addParameter(param);
                }
            }
            return this.execute(statement);
        }

        @Override
        @Nonnull
        public SqlResult execute(@Nonnull SqlStatement statement) {
            return this.sqlService.execute(statement, this.sqlSecurityContext);
        }
    }

    private class CPSubsystemDelegate
    implements CPSubsystem {
        private final CPSubsystem cpSubsystem;

        CPSubsystemDelegate(CPSubsystem cpSubsystem) {
            this.cpSubsystem = cpSubsystem;
        }

        @Override
        @Nonnull
        public IAtomicLong getAtomicLong(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new AtomicLongPermission(name, "create"));
            return (IAtomicLong)SecureCallableImpl.this.getProxy(new IAtomicLongInvocationHandler(this.cpSubsystem.getAtomicLong(name)));
        }

        @Override
        @Nonnull
        public <E> IAtomicReference<E> getAtomicReference(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new AtomicReferencePermission(name, "create"));
            return (IAtomicReference)SecureCallableImpl.this.getProxy(new IAtomicReferenceInvocationHandler(this.cpSubsystem.getAtomicReference(name)));
        }

        @Override
        @Nonnull
        public ICountDownLatch getCountDownLatch(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new CountDownLatchPermission(name, "create"));
            return (ICountDownLatch)SecureCallableImpl.this.getProxy(new ICountDownLatchInvocationHandler(this.cpSubsystem.getCountDownLatch(name)));
        }

        @Override
        @Nonnull
        public FencedLock getLock(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new LockPermission(name, "create"));
            return (FencedLock)SecureCallableImpl.this.getProxy(new LockInvocationHandler(this.cpSubsystem.getLock(name)));
        }

        @Override
        @Nonnull
        public ISemaphore getSemaphore(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new SemaphorePermission(name, "create"));
            return (ISemaphore)SecureCallableImpl.this.getProxy(new ISemaphoreInvocationHandler(this.cpSubsystem.getSemaphore(name)));
        }

        @Override
        public CPMember getLocalCPMember() {
            return this.cpSubsystem.getLocalCPMember();
        }

        @Override
        public CPSubsystemManagementService getCPSubsystemManagementService() {
            throw new UnsupportedOperationException("CPSubsystemManagementService is not available!");
        }

        @Override
        public CPSessionManagementService getCPSessionManagementService() {
            throw new UnsupportedOperationException("CPSessionManagementService is not available!");
        }

        @Override
        public UUID addMembershipListener(CPMembershipListener listener) {
            return this.cpSubsystem.addMembershipListener(listener);
        }

        @Override
        public boolean removeMembershipListener(UUID id) {
            return this.cpSubsystem.removeMembershipListener(id);
        }

        @Override
        public UUID addGroupAvailabilityListener(CPGroupAvailabilityListener listener) {
            return this.cpSubsystem.addGroupAvailabilityListener(listener);
        }

        @Override
        public boolean removeGroupAvailabilityListener(UUID id) {
            return this.cpSubsystem.removeGroupAvailabilityListener(id);
        }
    }

    private class PNCounterHandler
    extends SecureInvocationHandler {
        PNCounterHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new PNCounterPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "PNCounter";
        }
    }

    private class CardinalityEstimatorHandler
    extends SecureInvocationHandler {
        CardinalityEstimatorHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new CardinalityEstimatorPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "cardinalityEstimator";
        }
    }

    private class CacheInvocationHandler
    extends SecureInvocationHandler {
        CacheInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new CachePermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "cache";
        }
    }

    private class ReplicatedMapInvocationHandler
    extends SecureInvocationHandler {
        ReplicatedMapInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            return null;
        }

        @Override
        public String getStructureName() {
            return "replicatedMap";
        }
    }

    private class FlakeIdGeneratorInvocationHandler
    extends SecureInvocationHandler {
        FlakeIdGeneratorInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new FlakeIdGeneratorPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "flakeIdGenerator";
        }
    }

    private class ISemaphoreInvocationHandler
    extends SecureInvocationHandler {
        ISemaphoreInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new SemaphorePermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "semaphore";
        }
    }

    private class ICountDownLatchInvocationHandler
    extends SecureInvocationHandler {
        ICountDownLatchInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new CountDownLatchPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "countDownLatch";
        }
    }

    private class IAtomicReferenceInvocationHandler
    extends SecureInvocationHandler {
        IAtomicReferenceInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new AtomicReferencePermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "atomicReference";
        }
    }

    private class IAtomicLongInvocationHandler
    extends SecureInvocationHandler {
        IAtomicLongInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new AtomicLongPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "atomicLong";
        }
    }

    private class MultiMapInvocationHandler
    extends SecureInvocationHandler {
        MultiMapInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new MultiMapPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "multiMap";
        }
    }

    private class IMapInvocationHandler
    extends SecureInvocationHandler {
        IMapInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            if (method.getName().equals("executeOnKey") || method.getName().equals("executeOnEntries")) {
                return new MapPermission(this.distributedObject.getName(), "put", "remove");
            }
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new MapPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "map";
        }
    }

    private class IListInvocationHandler
    extends SecureInvocationHandler {
        IListInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new ListPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "list";
        }
    }

    private class ISetInvocationHandler
    extends SecureInvocationHandler {
        ISetInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new SetPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "set";
        }
    }

    private class ITopicInvocationHandler
    extends SecureInvocationHandler {
        ITopicInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new TopicPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "topic";
        }
    }

    private class IQueueInvocationHandler
    extends SecureInvocationHandler {
        IQueueInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new QueuePermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "queue";
        }
    }

    private class LockInvocationHandler
    extends SecureInvocationHandler {
        LockInvocationHandler(DistributedObject distributedObject) {
            super(distributedObject);
        }

        @Override
        public Permission getPermission(Method method, Object[] args) {
            String action = this.getAction(method.getName());
            if (action == null) {
                return null;
            }
            return new LockPermission(this.distributedObject.getName(), action);
        }

        @Override
        public String getStructureName() {
            return "lock";
        }
    }

    private abstract class SecureInvocationHandler
    implements InvocationHandler {
        final DistributedObject distributedObject;
        private final Map<String, String> methodMap;

        SecureInvocationHandler(DistributedObject distributedObject) {
            this.distributedObject = distributedObject;
            this.methodMap = SecureCallableImpl.this.serviceToMethod.getOrDefault(this.getStructureName(), Collections.emptyMap());
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Permission permission = this.getPermission(method, args);
            if (permission != null) {
                SecureCallableImpl.this.checkPermission(permission);
            } else if (SecureCallableImpl.this.blockUnmappedActions) {
                throw new AccessControlException("Missing permission-mapping for `" + this.getStructureName() + "." + method.getName() + "()`. Action blocked!");
            }
            return method.invoke((Object)this.distributedObject, args);
        }

        DistributedObject getDistributedObject() {
            return this.distributedObject;
        }

        abstract Permission getPermission(Method var1, Object[] var2);

        abstract String getStructureName();

        String getAction(String methodName) {
            return this.methodMap.get(methodName);
        }
    }

    private class CacheManagerDelegate
    implements ICacheManager {
        private final ICacheManager cacheManager;

        CacheManagerDelegate(ICacheManager cacheManager) {
            this.cacheManager = cacheManager;
        }

        @Override
        public <K, V> ICache<K, V> getCache(String name) {
            SecureCallableImpl.this.checkPermission(new CachePermission(name, "create"));
            return (ICache)SecureCallableImpl.this.getProxy(new CacheInvocationHandler(this.cacheManager.getCache(name)));
        }
    }

    private class HazelcastInstanceDelegate
    implements HazelcastInstance {
        private final HazelcastInstance instance;

        HazelcastInstanceDelegate(HazelcastInstance instance) {
            this.instance = instance;
        }

        @Override
        public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
            SecureCallableImpl.this.checkPermission(new TransactionPermission());
            return this.instance.executeTransaction(task);
        }

        @Override
        public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
            SecureCallableImpl.this.checkPermission(new TransactionPermission());
            return this.instance.executeTransaction(options, task);
        }

        @Override
        public TransactionContext newTransactionContext() {
            SecureCallableImpl.this.checkPermission(new TransactionPermission());
            return this.instance.newTransactionContext();
        }

        @Override
        public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
            SecureCallableImpl.this.checkPermission(new TransactionPermission());
            return this.instance.newTransactionContext(options);
        }

        @Override
        @Nonnull
        public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public ConcurrentMap<String, Object> getUserContext() {
            return this.instance.getUserContext();
        }

        @Override
        @Nonnull
        public <E> IQueue<E> getQueue(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new QueuePermission(name, "create"));
            return (IQueue)SecureCallableImpl.this.getProxy(new IQueueInvocationHandler(this.instance.getQueue(name)));
        }

        @Override
        @Nonnull
        public <E> ITopic<E> getTopic(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new TopicPermission(name, "create"));
            return (ITopic)SecureCallableImpl.this.getProxy(new ITopicInvocationHandler(this.instance.getTopic(name)));
        }

        @Override
        @Nonnull
        public <E> ISet<E> getSet(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new SetPermission(name, "create"));
            return (ISet)SecureCallableImpl.this.getProxy(new ISetInvocationHandler(this.instance.getSet(name)));
        }

        @Override
        @Nonnull
        public <E> IList<E> getList(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new ListPermission(name, "create"));
            return (IList)SecureCallableImpl.this.getProxy(new IListInvocationHandler(this.instance.getList(name)));
        }

        @Override
        @Nonnull
        public <K, V> IMap<K, V> getMap(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new MapPermission(name, "create"));
            return (IMap)SecureCallableImpl.this.getProxy(new IMapInvocationHandler(this.instance.getMap(name)));
        }

        @Override
        @Nonnull
        public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new ReplicatedMapPermission(name, "create"));
            return (ReplicatedMap)SecureCallableImpl.this.getProxy(new ReplicatedMapInvocationHandler(this.instance.getReplicatedMap(name)));
        }

        @Override
        @Nonnull
        public <K, V> MultiMap<K, V> getMultiMap(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new MultiMapPermission(name, "create"));
            return (MultiMap)SecureCallableImpl.this.getProxy(new MultiMapInvocationHandler(this.instance.getMultiMap(name)));
        }

        @Override
        @Nonnull
        public IExecutorService getExecutorService(@Nonnull String name) {
            throw new UnsupportedOperationException("It is not allowed to use Executor Service proxy within an executor.");
        }

        @Override
        @Nonnull
        public DurableExecutorService getDurableExecutorService(@Nonnull String name) {
            throw new UnsupportedOperationException("It is not allowed to use Durable Executor Service proxy within an executor.");
        }

        @Override
        @Nonnull
        public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new FlakeIdGeneratorPermission(name, "create"));
            return (FlakeIdGenerator)SecureCallableImpl.this.getProxy(new FlakeIdGeneratorInvocationHandler(this.instance.getFlakeIdGenerator(name)));
        }

        @Override
        @Nonnull
        public CardinalityEstimator getCardinalityEstimator(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new CardinalityEstimatorPermission(name, "create"));
            return (CardinalityEstimator)SecureCallableImpl.this.getProxy(new CardinalityEstimatorHandler(this.instance.getCardinalityEstimator(name)));
        }

        @Override
        @Nonnull
        public PNCounter getPNCounter(@Nonnull String name) {
            SecureCallableImpl.this.checkPermission(new PNCounterPermission(name, "create"));
            return (PNCounter)SecureCallableImpl.this.getProxy(new PNCounterHandler(this.instance.getPNCounter(name)));
        }

        @Override
        @Nonnull
        public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
            throw new UnsupportedOperationException("It is not allowed to use Scheduled Executor Service proxy within an executor.");
        }

        @Override
        public ICacheManager getCacheManager() {
            return new CacheManagerDelegate(this.instance.getCacheManager());
        }

        @Override
        @Nonnull
        public Cluster getCluster() {
            return this.instance.getCluster();
        }

        @Override
        @Nonnull
        public Endpoint getLocalEndpoint() {
            return this.instance.getLocalEndpoint();
        }

        @Override
        @Nonnull
        public String getName() {
            return this.instance.getName();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<DistributedObject> getDistributedObjects() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public Config getConfig() {
            return this.instance.getConfig();
        }

        @Override
        @Nonnull
        public PartitionService getPartitionService() {
            return this.instance.getPartitionService();
        }

        @Override
        @Nonnull
        public ClientService getClientService() {
            return this.instance.getClientService();
        }

        @Override
        @Nonnull
        public LoggingService getLoggingService() {
            return this.instance.getLoggingService();
        }

        @Override
        @Nonnull
        public LifecycleService getLifecycleService() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public SplitBrainProtectionService getSplitBrainProtectionService() {
            return this.instance.getSplitBrainProtectionService();
        }

        @Override
        @Nonnull
        public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
            return this.instance.getRingbuffer(name);
        }

        @Override
        @Nonnull
        public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
            return this.instance.getReliableTopic(name);
        }

        @Override
        @Nonnull
        public HazelcastXAResource getXAResource() {
            return this.instance.getXAResource();
        }

        @Override
        @Nonnull
        public CPSubsystem getCPSubsystem() {
            return new CPSubsystemDelegate(this.instance.getCPSubsystem());
        }

        @Override
        @Nonnull
        public SqlService getSql() {
            return new SqlServiceDelegate((SqlServiceImpl)this.instance.getSql(), ((SecureCallableImpl)SecureCallableImpl.this).node.securityContext.createSqlContext(SecureCallableImpl.this.subject));
        }

        @Override
        @Nonnull
        public JetService getJet() {
            return this.instance.getJet();
        }
    }
}

