/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public final class LdapUtils {
    private LdapUtils() {
    }

    public static String getAttributeValue(Attributes attributes, String attribute) throws NamingException {
        Object value;
        Attribute attr = attributes.get(attribute);
        if (attr != null && (value = attr.get()) != null) {
            return value instanceof byte[] ? new String((byte[])value, StandardCharsets.UTF_8) : value.toString();
        }
        return null;
    }

    public static Collection<String> getAttributeValues(Attributes attributes, String attribute) throws NamingException {
        Attribute attr;
        HashSet<String> names = new HashSet<String>();
        Attribute attribute2 = attr = attribute != null && attributes != null ? attributes.get(attribute) : null;
        if (attr != null) {
            NamingEnumeration<?> values = attr.getAll();
            while (values.hasMore()) {
                Object value = values.next();
                if (value == null) continue;
                String name = value instanceof byte[] ? new String((byte[])value, StandardCharsets.UTF_8) : value.toString();
                names.add(name);
            }
        }
        return names;
    }

    public static Collection<String> getAttributeValues(LdapName ldapName, String attribute) throws NamingException {
        HashSet<String> names = new HashSet<String>();
        for (Rdn rdn : ldapName.getRdns()) {
            names.addAll(LdapUtils.getAttributeValues(rdn.toAttributes(), attribute));
        }
        return names;
    }

    public static String replacePlaceholders(String filter, String ... placeHolders) {
        for (int i = 0; i < placeHolders.length; i += 2) {
            filter = filter.replace(placeHolders[i * 2], LdapUtils.escapeSearchValue(placeHolders[i * 2 + 1]));
        }
        return filter;
    }

    public static String escapeSearchValue(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

