/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.GlobalIndexPartitionTracker;
import com.hazelcast.query.impl.HDOrderedIndexStore;
import com.hazelcast.query.impl.HDUnorderedIndexStore;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;

public class HDIndexImpl
extends AbstractIndex {
    private static final int UNINDEXED = -1;
    private int indexedPartition = -1;

    public HDIndexImpl(Node node, IndexConfig config, EnterpriseSerializationService ss, Extractors extractors, PerIndexStats stats, String mapName) {
        super(node, config, ss, extractors, IndexCopyBehavior.NEVER, stats, mapName);
    }

    @Override
    protected IndexStore createIndexStore(Node node, IndexConfig config, PerIndexStats stats, String mapName) {
        EnterpriseSerializationService ess = (EnterpriseSerializationService)this.ss;
        MemoryAllocator malloc = stats.wrapMemoryAllocator(ess.getCurrentMemoryAllocator());
        OnHeapEntryFactory entryFactory = new OnHeapEntryFactory(ess, this.extractors);
        switch (config.getType()) {
            case SORTED: {
                return new HDOrderedIndexStore(ess, malloc, entryFactory);
            }
            case HASH: {
                return new HDUnorderedIndexStore(ess, malloc, entryFactory);
            }
            case BITMAP: {
                throw new IllegalArgumentException("Bitmap indexes are not supported by NATIVE storage");
            }
        }
        throw new IllegalArgumentException("unexpected index type: " + (Object)((Object)config.getType()));
    }

    @Override
    public void clear() {
        this.indexedPartition = -1;
        super.clear();
    }

    @Override
    public void destroy() {
        this.indexStore.destroy();
        super.destroy();
    }

    @Override
    public boolean hasPartitionIndexed(int partitionId) {
        return this.indexedPartition == partitionId;
    }

    @Override
    public boolean allPartitionsIndexed(int ownedPartitionCount) {
        return this.indexedPartition != -1;
    }

    @Override
    public void beginPartitionUpdate() {
    }

    @Override
    public void markPartitionAsIndexed(int partitionId) {
        assert (this.indexedPartition == -1);
        this.indexedPartition = partitionId;
    }

    @Override
    public void markPartitionAsUnindexed(int partitionId) {
        this.indexedPartition = -1;
    }

    @Override
    public GlobalIndexPartitionTracker.PartitionStamp getPartitionStamp() {
        return null;
    }

    @Override
    public boolean validatePartitionStamp(long stamp) {
        return false;
    }

    static class OnHeapEntryFactory
    implements MapEntryFactory<QueryableEntry> {
        private final EnterpriseSerializationService ess;
        private final Extractors extractors;

        OnHeapEntryFactory(EnterpriseSerializationService ess, Extractors extractors) {
            this.ess = ess;
            this.extractors = extractors;
        }

        @Override
        public CachedQueryEntry create(Data key, Data value) {
            Data heapData = this.toHeapData(key);
            Data heapValue = this.toHeapData(value);
            return new CachedQueryEntry(this.ess, heapData, heapValue, this.extractors);
        }

        private Data toHeapData(Data data) {
            if (data instanceof NativeMemoryData) {
                NativeMemoryData nativeMemoryData = (NativeMemoryData)data;
                if (nativeMemoryData.totalSize() == 0) {
                    return null;
                }
                return this.ess.toData((Object)nativeMemoryData, DataType.HEAP);
            }
            return data;
        }
    }
}

