/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.hidensity.impl.TieredStoreRecordProcessor;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.CompactorConstructorFn;
import com.hazelcast.internal.tstore.compaction.IndexBasedHLogCompactorConstructorFn;
import com.hazelcast.internal.tstore.compaction.LogBasedHLogCompactorConstructorFn;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.map.impl.EntryCostEstimator;
import com.hazelcast.map.impl.NotifiableIterator;
import com.hazelcast.map.impl.OwnedEntryCostEstimatorFactory;
import com.hazelcast.map.impl.TieredStoreMapEntryCostEstimator;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecordFactory;
import com.hazelcast.map.impl.recordstore.Storage;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class TieredStorageImpl
implements Storage<Data, TieredStoreRecord> {
    private static final AddressRemapper<TieredStoreRecord> NOP_REMAPPER = (record, oldLogicalAddress, newLogicalAddress) -> newLogicalAddress;
    private final Index index;
    private final TieredStoreRecordProcessor recordProcessor;
    private final TieredStoreRecordAccessor recordAccessor;
    private final TieredStoreRecordFactory recordFactory;
    private final Epoch epoch;
    private final State state;
    private final Device device;
    private EntryCostEstimator<NativeMemoryData, TieredStoreRecord> entryCostEstimator;
    private final EnterpriseSerializationService ess;
    private final AddressRemapper<TieredStoreRecord> addressUpdater;
    private final TStoreUserId userId;
    private final int partitionId;
    private final CompactionManager compactionManager;
    private final CompactorConstructorFn logBasedHLogCompactorConstructorFn;
    private final CompactorConstructorFn indexBasedHLogCompactorConstructorFn;

    public TieredStorageImpl(TStoreUserId userId, int partitionId, TieredStoreRecordFactory recordFactory, Epoch epoch, HazelcastMemoryManager memoryManager, CompactionManager compactionManager, boolean statsEnabled) {
        this.recordFactory = recordFactory;
        this.recordProcessor = recordFactory.getRecordProcessor();
        this.recordAccessor = this.recordProcessor.getRecordAccessor();
        this.ess = this.recordProcessor.getSerializationService();
        this.epoch = epoch;
        this.userId = userId;
        this.state = new State(epoch.maxThreads());
        this.entryCostEstimator = statsEnabled ? new TieredStoreMapEntryCostEstimator() : OwnedEntryCostEstimatorFactory.ZERO_SIZE_ESTIMATOR;
        this.partitionId = partitionId;
        this.addressUpdater = new AddressUpdaterImpl();
        IndexDependencies dependencies = new IndexDependencies(this.recordProcessor, this.recordAccessor, this.addressUpdater, memoryManager.getSystemAllocator(), this.ess);
        this.index = new Index(epoch, this.state, epoch.maxThreads(), dependencies);
        HybridLogImpl log = (HybridLogImpl)this.recordAccessor.getHybridLog();
        this.logBasedHLogCompactorConstructorFn = new LogBasedHLogCompactorConstructorFn(this.recordAccessor, log, this.index, this.state, epoch);
        this.indexBasedHLogCompactorConstructorFn = new IndexBasedHLogCompactorConstructorFn(this.index, this.state, log, log.getDevice(), epoch);
        compactionManager.addCompactorConstructorFn(userId, partitionId, this.logBasedHLogCompactorConstructorFn);
        compactionManager.addCompactorConstructorFn(userId, partitionId, this.indexBasedHLogCompactorConstructorFn);
        this.compactionManager = compactionManager;
        this.device = log.getDevice();
    }

    @Override
    public void put(Data key, TieredStoreRecord record) {
        assert (record.isPinned());
        int threadIndex = this.threadIndex();
        while (true) {
            if (!this.recordProcessor.isMutable(record.getLogicalAddress())) {
                record = this.recordProcessor.getHybridLog().readRecordForUpdate(record.getLogicalAddress(), this.recordAccessor.getTieredStoreSlotAccessor(), NOP_REMAPPER);
            }
            assert (this.recordProcessor.isMutable(record.getLogicalAddress()));
            long status = this.index.putRaw(threadIndex, key, record.getLogicalAddress(), -1L);
            assert (status != -2L);
            if (status == -1L) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status >= 0L) break;
            this.recordProcessor.readRecordForUpdate(-status, this.addressUpdater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TieredStoreRecord updateRecordValue(Data key, TieredStoreRecord oldRecord, Object value) {
        long status;
        assert (this.index.tryLock(this.threadIndex(), key.hash64()) < 0L);
        Object newValue = this.ess.toData(value, DataType.HEAP);
        if (oldRecord.isUpdatableInPlace((Data)newValue) && this.recordProcessor.isMutable(oldRecord.getLogicalAddress())) {
            oldRecord.setValueSafe((Data)newValue);
            return oldRecord;
        }
        TieredStoreRecord newRecord = null;
        int threadIndex = this.threadIndex();
        while (true) {
            if (newRecord == null) {
                while (!this.recordProcessor.isInMemory(oldRecord) || !oldRecord.pin()) {
                    oldRecord = this.recordProcessor.readRecordForUpdate(oldRecord.getLogicalAddress(), NOP_REMAPPER);
                }
                try {
                    assert (this.recordProcessor.isInMemory(oldRecord));
                    newRecord = this.recordFactory.newRecord(oldRecord, (Data)newValue);
                }
                finally {
                    oldRecord.unpin();
                }
            } else if (!this.recordProcessor.isMutable(newRecord.getLogicalAddress())) {
                newRecord = this.recordProcessor.readRecordForUpdate(newRecord.getLogicalAddress(), NOP_REMAPPER);
            }
            long oldRecordLogicalAddress = oldRecord.getLogicalAddress();
            long newRecordLogicalAddress = newRecord.getLogicalAddress();
            status = this.index.putRaw(threadIndex, key, newRecordLogicalAddress, oldRecordLogicalAddress);
            assert (status != 0L);
            if (status == -2L) {
                oldRecord = this.get(key);
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status == -1L) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status >= 0L) break;
            this.recordProcessor.readRecordForUpdate(-status, this.addressUpdater);
        }
        assert (status > 0L);
        return newRecord;
    }

    @Override
    public TieredStoreRecord get(Data key) {
        TieredStoreRecord readRecord;
        int threadIndex = this.threadIndex();
        while (true) {
            TieredStoreRecord status = this.index.get(threadIndex, key);
            assert (status != Index.UNEXPECTED_RECORD);
            if (status == Index.RETRY_RECORD) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status == null || !status.isPending()) {
                return status;
            }
            assert (status.isPending());
            readRecord = this.recordProcessor.readRecordForReadOnly(status.getLogicalAddress(), this.addressUpdater);
            if (TieredStorageImpl.keyEquals(readRecord.address(), key)) break;
        }
        return readRecord;
    }

    @Override
    public TieredStoreRecord getIfSameKey(Data key) {
        throw new UnsupportedOperationException("TieredStorageImpl#getIfSameKey");
    }

    @Override
    public void removeRecord(Data key, TieredStoreRecord record) {
        int threadIndex = this.threadIndex();
        long expectedLogicalAddress = record.getLogicalAddress();
        while (true) {
            long status = this.index.removeRaw(threadIndex, key, expectedLogicalAddress);
            assert (status != 0L);
            if (status == -1L) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status == -2L) {
                TieredStoreRecord newRecord = this.get(key);
                expectedLogicalAddress = newRecord.getLogicalAddress();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status >= 0L) break;
            this.recordProcessor.readRecordForUpdate(-status, this.addressUpdater);
        }
    }

    @Override
    public boolean containsKey(Data key) {
        long status;
        int threadIndex = this.threadIndex();
        while (true) {
            status = this.index.getRaw(threadIndex, key, -1L, true);
            assert (status != -2L);
            if (status == -1L) {
                Thread.yield();
                this.refreshEpochAndState(threadIndex);
                continue;
            }
            if (status >= 0L) break;
            this.recordProcessor.readRecordForReadOnly(-status, this.addressUpdater);
        }
        assert (status >= 0L);
        return status != 0L;
    }

    @Override
    public Iterator<Map.Entry<Data, TieredStoreRecord>> mutationTolerantIterator() {
        return new CachedEntryIterator(this.index.iterator(this.threadIndex()));
    }

    @Override
    public int size() {
        return (int)Math.min(this.index.size(), Integer.MAX_VALUE);
    }

    @Override
    public boolean isEmpty() {
        return this.index.size() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(boolean isDuringShutdown) {
        int threadIndex;
        boolean wasRegisteredToEpoch = this.epoch.isCurrentThreadRegistered();
        if (wasRegisteredToEpoch) {
            threadIndex = this.epoch.getCurrentThreadIndex();
        } else {
            threadIndex = this.epoch.register();
            this.state.register(threadIndex);
        }
        try {
            this.index.clear(threadIndex);
        }
        finally {
            if (!wasRegisteredToEpoch) {
                this.state.unregister(threadIndex);
                this.epoch.unregister(threadIndex);
            }
        }
        this.entryCostEstimator.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean isDuringShutdown) {
        int threadIndex;
        this.compactionManager.removeCompactorConstructorFn(this.userId, this.partitionId, this.logBasedHLogCompactorConstructorFn);
        this.compactionManager.removeCompactorConstructorFn(this.userId, this.partitionId, this.indexBasedHLogCompactorConstructorFn);
        this.device.terminateCompactors();
        boolean wasRegisteredToEpoch = this.epoch.isCurrentThreadRegistered();
        if (wasRegisteredToEpoch) {
            threadIndex = this.epoch.getCurrentThreadIndex();
        } else {
            threadIndex = this.epoch.register();
            this.state.register(threadIndex);
        }
        try {
            this.index.close(threadIndex);
            this.epoch.bump(threadIndex, (threadIdx, actionEpoch) -> this.recordProcessor.getHybridLog().dispose());
        }
        finally {
            if (!wasRegisteredToEpoch) {
                this.state.unregister(threadIndex);
                this.epoch.unregister(threadIndex);
            }
        }
    }

    @Override
    public EntryCostEstimator getEntryCostEstimator() {
        return this.entryCostEstimator;
    }

    @Override
    public void setEntryCostEstimator(EntryCostEstimator entryCostEstimator) {
        this.entryCostEstimator = entryCostEstimator;
    }

    @Override
    public Iterable<EntryView> getRandomSamples(int sampleCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MapKeysWithCursor fetchKeys(IterationPointer[] pointers, int size) {
        int threadIndex = this.threadIndex();
        IterationPointer[] updatedPointers = new IterationPointer[pointers.length];
        for (int i = 0; i < updatedPointers.length; ++i) {
            updatedPointers[i] = new IterationPointer(pointers[i]);
        }
        ArrayList<Data> keys = new ArrayList<Data>(size);
        while (true) {
            updatedPointers = this.index.fetchEntries(threadIndex, size - keys.size(), updatedPointers, record -> keys.add(this.recordProcessor.convertData(record.getKey(), DataType.HEAP)));
            if (keys.size() >= size || !Index.isMoreToVisit(updatedPointers)) break;
            Thread.yield();
            this.refreshEpochAndState(threadIndex);
        }
        return new MapKeysWithCursor((List<Data>)keys, updatedPointers);
    }

    @Override
    public MapEntriesWithCursor fetchEntries(IterationPointer[] pointers, int size) {
        int threadIndex = this.threadIndex();
        IterationPointer[] updatedPointers = new IterationPointer[pointers.length];
        for (int i = 0; i < updatedPointers.length; ++i) {
            updatedPointers[i] = new IterationPointer(pointers[i]);
        }
        ArrayList<Map.Entry<Data, Data>> entries = new ArrayList<Map.Entry<Data, Data>>(size);
        while (true) {
            updatedPointers = this.index.fetchEntries(threadIndex, size - entries.size(), updatedPointers, record -> {
                Data key = this.recordProcessor.convertData(record.getKey(), DataType.HEAP);
                Data value = this.recordProcessor.convertData(record.getValue(), DataType.HEAP);
                entries.add(new AbstractMap.SimpleEntry<Data, Data>(key, value));
            });
            if (entries.size() >= size || !Index.isMoreToVisit(updatedPointers)) break;
            Thread.yield();
            this.refreshEpochAndState(threadIndex);
        }
        return new MapEntriesWithCursor((List<Map.Entry<Data, Data>>)entries, updatedPointers);
    }

    @Override
    public Data extractDataKeyFromLazy(EntryView entryView) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Data toBackingDataKeyFormat(Data key) {
        return this.get(key).getKey();
    }

    @Override
    public void beforeOperation() {
        int threadIndex = this.epoch.register();
        this.state.register(threadIndex);
    }

    @Override
    public void afterOperation() {
        int threadIndex = this.threadIndex();
        this.state.unregister(threadIndex);
        this.epoch.unregister(threadIndex);
        this.device.completePendingSegmentDeletes();
    }

    private int threadIndex() {
        return this.epoch.getCurrentThreadIndex();
    }

    private void refreshEpochAndState(int threadIndex) {
        this.epoch.refresh(threadIndex);
        this.state.refresh(threadIndex);
    }

    public static boolean keyEquals(long physicalRecord, Data key) {
        long recordKey = TieredStoreRecordAccessor.readKeyAddress(physicalRecord);
        return NativeMemoryDataUtil.equals(recordKey, key);
    }

    public Index getIndex() {
        return this.index;
    }

    public TieredStoreRecordProcessor getRecordProcessor() {
        return this.recordProcessor;
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    public State getState() {
        return this.state;
    }

    private class CachedEntryIterator
    implements Iterator<Map.Entry<Data, TieredStoreRecord>>,
    NotifiableIterator {
        private final MapEntry entry;
        private final Index.Iterator it;
        private int threadIndex;

        CachedEntryIterator(Index.Iterator it) {
            this.entry = new MapEntry();
            this.it = it;
            this.threadIndex = TieredStorageImpl.this.threadIndex();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext(this.threadIndex);
        }

        @Override
        public Map.Entry<Data, TieredStoreRecord> next() {
            TieredStoreRecord record = this.it.next(this.threadIndex);
            return this.entry.init(record);
        }

        @Override
        public void onBeforeIteration() {
            this.threadIndex = TieredStorageImpl.this.threadIndex();
        }
    }

    protected class MapEntry
    implements Map.Entry<Data, TieredStoreRecord> {
        private TieredStoreRecord record;

        protected MapEntry() {
        }

        protected MapEntry init(TieredStoreRecord record) {
            this.record = record;
            return this;
        }

        @Override
        public Data getKey() {
            return this.record.getKey();
        }

        @Override
        public TieredStoreRecord getValue() {
            return this.record;
        }

        @Override
        public TieredStoreRecord setValue(TieredStoreRecord value) {
            TieredStoreRecord oldValue = this.record;
            this.record = value;
            return oldValue;
        }
    }

    public static class IndexDependencies
    implements Index.Dependencies {
        private static final AtomicLongFieldUpdater<IndexDependencies> MEMORY_CONSUMPTION_BYTES = AtomicLongFieldUpdater.newUpdater(IndexDependencies.class, "memoryConsumptionBytes");
        private final TieredStoreRecordProcessor recordProcessor;
        private final TieredStoreRecordAccessor recordAccessor;
        private final AddressRemapper<TieredStoreRecord> addressRemapper;
        private final MemoryAllocator allocator;
        private final EnterpriseSerializationService ess;
        private volatile long memoryConsumptionBytes;

        public IndexDependencies(TieredStoreRecordProcessor recordProcessor, TieredStoreRecordAccessor recordAccessor, AddressRemapper<TieredStoreRecord> addressRemapper, MemoryAllocator allocator, EnterpriseSerializationService ess) {
            this.recordProcessor = recordProcessor;
            this.recordAccessor = recordAccessor;
            this.allocator = allocator;
            this.ess = ess;
            this.addressRemapper = addressRemapper;
        }

        @Override
        public long allocateBuckets(long count) {
            long address = this.allocator.allocate(count * 128L);
            MEMORY_CONSUMPTION_BYTES.addAndGet(this, count * 128L);
            return address;
        }

        @Override
        public void freeBuckets(long buckets, long count) {
            this.allocator.free(buckets, count * 128L);
            MEMORY_CONSUMPTION_BYTES.addAndGet(this, -count * 128L);
        }

        @Override
        public long physicalAddress(long logicalAddress) {
            HybridLog hybridLog = this.recordProcessor.getHybridLog();
            return hybridLog.isInMemory(logicalAddress) ? hybridLog.asPhysicalAddress(logicalAddress) : 0L;
        }

        @Override
        public long physicalAddressForUpdate(long logicalAddress) {
            HybridLog log = this.recordProcessor.getHybridLog();
            if (!log.isMutable(logicalAddress)) {
                return 0L;
            }
            return log.asPhysicalAddress(logicalAddress);
        }

        @Override
        public long readRecordForUpdate(long logicalAddress) {
            TieredStoreRecord record = this.recordProcessor.readRecordForUpdate(logicalAddress, NOP_REMAPPER);
            return record.getLogicalAddress();
        }

        @Override
        public long readRecordAndDoRemapping(long logicalAddress) {
            TieredStoreRecord record = this.recordProcessor.readRecordForReadOnly(logicalAddress, this.addressRemapper);
            return record.getLogicalAddress();
        }

        @Override
        public byte[] readRecordFromDevice(long logicalAddress) {
            return this.recordProcessor.readRecordFromDevice(logicalAddress);
        }

        @Override
        public void pinRecord(long logicalAddress) {
            this.recordProcessor.getHybridLog().pinAddress(logicalAddress);
        }

        @Override
        public void unpinRecord(long logicalAddress) {
            this.recordProcessor.getHybridLog().unpinAddress(logicalAddress);
        }

        @Override
        public TieredStoreRecord makeRecord(long physicalAddress, long logicalAddress) {
            TieredStoreRecord record = this.recordProcessor.newRecord();
            record.reset(physicalAddress, logicalAddress, -1);
            return record;
        }

        @Override
        public void keyHashAndNext(long logicalRecord, Index.LongPair keyHashAndNext) {
            long physicalRecord = this.physicalAddress(logicalRecord);
            if (physicalRecord == 0L) {
                byte[] record = this.recordProcessor.readRecordFromDevice(logicalRecord);
                keyHashAndNext.value1 = TieredStoreRecordAccessor.keyHash64(record);
                keyHashAndNext.value2 = TieredStoreRecordAccessor.getNextRecordAddress(record);
            } else {
                long recordKeyAddress = TieredStoreRecordAccessor.readKeyAddress(physicalRecord);
                keyHashAndNext.value1 = NativeMemoryDataUtil.hash64(recordKeyAddress);
                keyHashAndNext.value2 = TieredStoreRecordAccessor.getNextRecordAddress(physicalRecord);
            }
        }

        @Override
        public long keyHash(long physicalRecord) {
            long recordKeyAddress = TieredStoreRecordAccessor.readKeyAddress(physicalRecord);
            return NativeMemoryDataUtil.hash64(recordKeyAddress);
        }

        @Override
        public void markAsReachable(long logicalRecord) {
            if (!this.recordProcessor.isMutable(logicalRecord)) {
                throw new IllegalStateException("only records in mutable region can be marked as reachable.");
            }
            this.recordAccessor.setNotDummy(logicalRecord);
        }

        @Override
        public void markAsNotReachable(long logicalRecord) {
            if (!this.recordProcessor.isMutable(logicalRecord)) {
                return;
            }
            this.recordAccessor.setDummy(logicalRecord);
        }

        @Override
        public EnterpriseSerializationService serializationService() {
            return this.ess;
        }

        @Override
        public void onDispose() {
            long unreleasedNativeMemory = MEMORY_CONSUMPTION_BYTES.get(this);
            Invariants.equals(0L, unreleasedNativeMemory, "Index has been disposed, native memory consumption by this Index instance should be zero. Is there a memory leak?");
        }
    }

    public class AddressUpdaterImpl
    implements AddressRemapper<TieredStoreRecord> {
        @Override
        public long remap(TieredStoreRecord record, long oldLogicalAddress, long newLogicalAddressCandidate) {
            long result;
            int threadIndex = TieredStorageImpl.this.threadIndex();
            Data key = record.getKey();
            while (true) {
                result = TieredStorageImpl.this.index.remap(threadIndex, key, oldLogicalAddress, newLogicalAddressCandidate);
                assert (result != -2L);
                assert (result != 0L);
                if (result != -1L) break;
                Thread.yield();
                TieredStorageImpl.this.refreshEpochAndState(threadIndex);
            }
            assert (result > 0L);
            return result;
        }
    }
}

