/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAddressTranslator;
import com.hazelcast.internal.memory.impl.EndiannessUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;

public class TieredStoreSlotAccessor
implements InMemorySlotAccessor<TieredStoreRecord, TieredStoreRecord> {
    private final TieredStoreRecordAccessor recordAccessor;

    public TieredStoreSlotAccessor(TieredStoreRecordAccessor recordAccessor) {
        this.recordAccessor = recordAccessor;
    }

    @Override
    public int length(byte[] recordPart) {
        return EndiannessUtil.readInt(EndiannessUtil.BYTE_ARRAY_ACCESS, recordPart, 8L, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
    }

    @Override
    public int headerSize() {
        return 12;
    }

    @Override
    public Data readValue(byte[] record) {
        int keySize = EndiannessUtil.readInt(EndiannessUtil.BYTE_ARRAY_ACCESS, record, 12L, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        assert (keySize > 0);
        int valueOffset = 16 + keySize;
        int valueSize = EndiannessUtil.readInt(EndiannessUtil.BYTE_ARRAY_ACCESS, record, valueOffset, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        byte[] payload = new byte[valueSize];
        System.arraycopy(record, valueOffset + 4, payload, 0, valueSize);
        return new HeapData(payload);
    }

    @Override
    public TieredStoreRecord prepare(long slotLogicalAddress, MemoryAddressTranslator translator) {
        long physicalAddress = translator.asPhysicalAddress(slotLogicalAddress);
        return this.recordAccessor.newRecord().reset(physicalAddress, slotLogicalAddress, -1);
    }

    @Override
    public int size(TieredStoreRecord preparedSlot) {
        return preparedSlot.size();
    }

    @Override
    public boolean isAlive(TieredStoreRecord preparedSlot) {
        return true;
    }

    @Override
    public TieredStoreRecord asEntry(TieredStoreRecord preparedSlot) {
        return preparedSlot;
    }

    @Override
    public boolean lock(TieredStoreRecord preparedSlot) {
        preparedSlot.lock();
        return true;
    }

    @Override
    public void unlock(TieredStoreRecord preparedSlot) {
        preparedSlot.unlock();
    }
}

