/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.hidensity.impl.TieredStoreRecordProcessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.record.TieredStoreRecord;

public final class TieredStoreRecordFactory
implements RecordFactory<Data> {
    private final TieredStoreRecordProcessor recordProcessor;
    private final MapContainer mapContainer;

    public TieredStoreRecordFactory(MapContainer mapContainer, TieredStoreRecordProcessor recordProcessor) {
        this.recordProcessor = recordProcessor;
        this.mapContainer = mapContainer;
    }

    public TieredStoreRecord newRecord(Data key, Object value) {
        assert (key != null);
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        boolean hasHotRestart = mapConfig.getHotRestartConfig().isEnabled();
        if (mapConfig.isPerEntryStatsEnabled()) {
            return this.newHDRecordWithExtras(key, value, 28);
        }
        if (!hasEviction && !hasHotRestart) {
            return this.newHDRecordWithExtras(key, value, 4);
        }
        throw new IllegalStateException("No tiered-store record type found matching with the provided " + mapConfig);
    }

    public TieredStoreRecord newRecord(TieredStoreRecord record, Data newValue) {
        Data key = record.getKey();
        int recordSize = this.recordProcessor.recordSize(key, newValue, record.getMetadataSize());
        TieredStoreRecord newRecord = this.recordProcessor.newPreparedRecord(recordSize);
        newRecord.setKey(key);
        newRecord.setValue(newValue);
        newRecord.setMetadata(record);
        return newRecord;
    }

    public TieredStoreRecord newHDRecordWithExtras(Data key, Object value, int metadataSize) {
        Data dataValue = this.recordProcessor.toData(value, DataType.HEAP);
        int recordSize = this.recordProcessor.recordSize(key, dataValue, metadataSize);
        TieredStoreRecord record = this.recordProcessor.newPreparedRecord(recordSize);
        record.setKey(key);
        record.setValue(dataValue);
        record.setLastAccessTime(-1L);
        return record;
    }

    public TieredStoreRecordProcessor getRecordProcessor() {
        return this.recordProcessor;
    }
}

