/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.util;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseType;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.extractor.LicenseExtractorV2;
import com.hazelcast.license.extractor.LicenseExtractorV3;
import com.hazelcast.license.extractor.LicenseExtractorV4;
import com.hazelcast.license.extractor.LicenseExtractorV5;
import com.hazelcast.license.extractor.LicenseExtractorV6;
import com.hazelcast.license.nlc.BuiltInLicenseProvider;
import com.hazelcast.license.nlc.BuiltInLicenseProviderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public final class LicenseHelper {
    public static final char[] chars = "dsx4MZQvo2tqegGLpWhCDXnPYzciBR3murF5SA7KIObaw1Vf6JNyjEl0UTkH".toCharArray();
    public static final char[] charsV5 = "az{Vh}r4:t$e]>_3%?@o|^p=.x*~<R;&c[s!+L-F7\u00a3IvY6ulkJB9jfQSdTWqGbX58ECw21nNM0PHKZmyUiOAgD".toCharArray();
    public static final char[] charsV6 = "\u00ea$\u00e8\u0107\u0106/<~|r\u00ff\u0178[>@{`\u00a3-)\u00e9_}\u010d:%]!*+=(&?.\u00e7;\u017aeToS^\u00fc\u00dc\u017e\u017cxml9nVO2CpEBYhLfavKPkijqGd5W0871ZgXusMJ3cUDz6ytHNIRA4FQwb".toCharArray();
    public static final char[] digits = "0123456789".toCharArray();
    public static final int lengthV6 = charsV6.length;
    public static final int lengthV5 = charsV5.length;
    public static final int length = chars.length;
    public static final int yearBase = 2000;
    public static final String INF_STR_ENTERPRISE = "HazelcastEnterprise";
    public static final String INF_STR_ENTERPRISE_HD = "HazelcastEnterpriseHD";
    public static final String INF_STR_MANCENTER = "ManagementCenter";
    public static final String INF_STR_SECURITY = "SecurityOnlyEnterprise";

    private LicenseHelper() {
    }

    public static char[] hash(char[] a) {
        if (a == null) {
            return new char[]{'0'};
        }
        int result = 1;
        for (char element : a) {
            result = 31 * result + element;
        }
        return Integer.toString(Math.abs(result)).toCharArray();
    }

    public static int extractHazelcastMajorMinorVersionAsInt(String version) {
        String[] parts = version.split("\\.");
        if (parts.length > 2) {
            int versionPart1 = Integer.parseInt(parts[0]);
            int versionPart2 = Integer.parseInt(parts[1]);
            return LicenseHelper.generateFinalStateOfIntVersion(versionPart1, versionPart2);
        }
        String[] betaParts = parts[1].split("-");
        int versionPart1 = Integer.parseInt(parts[0]);
        int versionPart2 = Integer.parseInt(betaParts[0]);
        return LicenseHelper.generateFinalStateOfIntVersion(versionPart1, versionPart2);
    }

    private static int generateFinalStateOfIntVersion(int versionPart1, int versionPart2) {
        boolean isDoubleDigit;
        boolean bl = isDoubleDigit = versionPart2 > 9 && versionPart2 < 100;
        if (isDoubleDigit) {
            return versionPart1 * 100 + versionPart2;
        }
        return versionPart1 * 10 + versionPart2;
    }

    public static LicenseVersion extractLicenseVersion(String version) {
        try {
            String[] parts = version.split("\\.");
            if (parts.length > 2) {
                int versionPart1 = Integer.parseInt(parts[0]);
                int versionPart2 = Integer.parseInt(parts[1]);
                int versionPart3 = Integer.parseInt(parts[2]);
                if (versionPart1 >= 5 && versionPart2 >= 2) {
                    return LicenseVersion.V6;
                }
                if (versionPart1 >= 3 && versionPart2 >= 10) {
                    return LicenseVersion.V5;
                }
                if (versionPart1 >= 3 && versionPart2 >= 7) {
                    return LicenseVersion.V4;
                }
                if (versionPart1 == 3 && versionPart2 == 6 && versionPart3 >= 1) {
                    return LicenseVersion.V4;
                }
                if (versionPart1 == 3 && versionPart2 == 6) {
                    return LicenseVersion.V3;
                }
                if (versionPart1 >= 3 && versionPart2 >= 5) {
                    return LicenseVersion.V2;
                }
                return LicenseVersion.V1;
            }
            String[] rcParts = parts[1].split("-");
            int versionPart1 = Integer.parseInt(parts[0]);
            int versionPart2 = Integer.parseInt(rcParts[0]);
            if (versionPart1 >= 5 && versionPart2 >= 2) {
                return LicenseVersion.V6;
            }
            if (versionPart1 >= 3 && versionPart2 >= 10) {
                return LicenseVersion.V5;
            }
            if (versionPart1 >= 3 && versionPart2 >= 7) {
                return LicenseVersion.V4;
            }
            if (versionPart1 == 3 && versionPart2 == 6) {
                return LicenseVersion.V3;
            }
            if (versionPart1 >= 3 && versionPart2 >= 5) {
                return LicenseVersion.V2;
            }
            return LicenseVersion.V1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return LicenseVersion.V1;
        }
    }

    public static boolean isExpired(License license) {
        return System.currentTimeMillis() > LicenseHelper.getExpiryDateWithGracePeriod(license).getTime();
    }

    public static Date getExpiryDateWithGracePeriod(License license) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(license.getExpiryDate());
        calendar.add(2, license.getGracePeriod());
        return calendar.getTime();
    }

    public static Date generateCreationDateFromExpiryDate(int monthDiffCreationAndExpDates, Date expiryDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(expiryDate);
        calendar.add(2, -monthDiffCreationAndExpDates);
        return calendar.getTime();
    }

    public static License getLicense(String licenseKey, String versionString) {
        License license;
        if (licenseKey == null) {
            throw new InvalidLicenseException("License Key not configured!");
        }
        try {
            license = LicenseExtractorV2.extractLicense(licenseKey);
        }
        catch (InvalidLicenseException e1) {
            try {
                license = LicenseExtractorV3.extractLicense(licenseKey);
            }
            catch (InvalidLicenseException e2) {
                try {
                    license = LicenseExtractorV4.extractLicense(licenseKey);
                }
                catch (InvalidLicenseException e3) {
                    try {
                        license = LicenseExtractorV5.extractLicense(licenseKey);
                    }
                    catch (InvalidLicenseException e) {
                        license = LicenseExtractorV6.extractLicense(licenseKey);
                    }
                }
            }
        }
        int version = LicenseHelper.extractHazelcastMajorMinorVersionAsInt(versionString);
        if (license.getHazelcastVersion() != 99 && license.getHazelcastVersion() != version) {
            throw new InvalidLicenseException("This license cannot work with your hazelcast version!");
        }
        if (license.isTrial().booleanValue() && LicenseHelper.isExpired(license)) {
            throw new InvalidLicenseException("Trial license has expired! Please contact your sales representative or contact support@hazelcast.com");
        }
        if (LicenseHelper.isExpired(license)) {
            throw new InvalidLicenseException("Enterprise License has expired! Please contact your sales representative or contact support@hazelcast.com");
        }
        return license;
    }

    public static License getBuiltInLicense() {
        BuiltInLicenseProviderFactory providerFactory = new BuiltInLicenseProviderFactory();
        BuiltInLicenseProvider licenseProvider = providerFactory.create();
        if (licenseProvider != null) {
            return licenseProvider.provide();
        }
        return null;
    }

    public static boolean isBuiltInLicense(License license) {
        if (license != null) {
            return license.getVersion() == LicenseVersion.V6 && license.getType() == LicenseType.CUSTOM && license.isOem() && license.getKey() == null && license.getCreationDate() == null;
        }
        return false;
    }

    public static License checkLicenseKey(String licenseKey, String versionString, LicenseType ... requiredLicenseTypes) {
        License license = LicenseHelper.getLicense(licenseKey, versionString);
        if (!Arrays.asList(requiredLicenseTypes).contains(license.getType())) {
            throw new InvalidLicenseException("Invalid License Type! Please contact your sales representative or contact support@hazelcast.com");
        }
        return license;
    }

    public static License checkLicenseKeyPerFeature(String licenseKey, String versionString, Feature feature) {
        License license = LicenseHelper.getLicense(licenseKey, versionString);
        LicenseHelper.checkLicensePerFeature(license, feature);
        return license;
    }

    public static void checkLicensePerFeature(License license, Feature feature) {
        if (!license.getFeatures().contains(feature)) {
            throw new InvalidLicenseException("The Feature " + feature.getText() + " is not enabled for your license key. Please contact your sales representative or contact support@hazelcast.com");
        }
    }

    public static License mapFeaturesForLegacyLicense(License license) {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        if (license.getType() == LicenseType.MANAGEMENT_CENTER) {
            featureList.add(Feature.MAN_CENTER);
        }
        if (license.getType() == LicenseType.ENTERPRISE_SECURITY_ONLY) {
            featureList.add(Feature.SECURITY);
        }
        if (license.getType() == LicenseType.ENTERPRISE) {
            LicenseHelper.addEnterpriseFeatures(featureList);
            if (license.getVersion() == LicenseVersion.V2) {
                featureList.add(Feature.HD_MEMORY);
            }
        }
        if (license.getVersion() == LicenseVersion.V3 && license.getType() == LicenseType.ENTERPRISE_HD) {
            LicenseHelper.addEnterpriseFeatures(featureList);
            featureList.add(Feature.HD_MEMORY);
            featureList.add(Feature.PERSISTENCE);
        }
        license.setFeatures(featureList);
        return license;
    }

    private static void addEnterpriseFeatures(List<Feature> featureList) {
        featureList.add(Feature.MAN_CENTER);
        featureList.add(Feature.WEB_SESSION);
        featureList.add(Feature.CLUSTERED_REST);
        featureList.add(Feature.CLUSTERED_JMX);
        featureList.add(Feature.SECURITY);
        featureList.add(Feature.WAN);
        featureList.add(Feature.ROLLING_UPGRADE);
    }
}

