/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseType;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.util.LicenseHelper;
import java.util.Calendar;

public class LicenseExtractorV2 {
    private static final int RESERVED = 25;

    public static License extractLicense(String licenseKey) throws InvalidLicenseException {
        char r;
        if (licenseKey == null || licenseKey.isEmpty()) {
            throw new IllegalArgumentException("License key can not be empty.");
        }
        String[] keyTokens = licenseKey.split("#");
        char[] originalKey = keyTokens[keyTokens.length - 1].toCharArray();
        if (LicenseHelper.length != originalKey.length) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        char[] key = new char[LicenseHelper.length];
        System.arraycopy(originalKey, 0, key, 0, LicenseHelper.length);
        char fp = key[24];
        key[24] = '\u0000';
        char lp = key[25];
        key[25] = '\u0000';
        char[] hash = LicenseHelper.hash(key);
        if (hash[0] != fp || hash[hash.length - 1] != lp) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        int ix = 0;
        boolean isTrial = key[LicenseExtractorV2.ix0(r = key[ix++])] == '1';
        char t = key[ix++];
        char type = key[LicenseExtractorV2.ix0(t)];
        LicenseType licenseType = null;
        switch (type) {
            case '0': {
                licenseType = LicenseType.MANAGEMENT_CENTER;
                break;
            }
            case '1': {
                licenseType = LicenseType.ENTERPRISE;
                break;
            }
            case '2': {
                licenseType = LicenseType.ENTERPRISE_SECURITY_ONLY;
            }
        }
        char d0 = key[ix++];
        char d1 = key[ix++];
        int day = LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(d0)]) * 10 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(d1)]);
        char m0 = key[ix++];
        char m1 = key[ix++];
        int month = LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(m0)]) * 10 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(m1)]);
        char y0 = key[ix++];
        char y1 = key[ix++];
        int year = 2000 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(y0)]) * 10 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(y1)]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        char n0 = key[ix++];
        char n1 = key[ix++];
        char n2 = key[ix++];
        char n3 = key[ix++];
        int nodes = LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(n0)]) * 1000 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(n1)]) * 100 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(n2)]) * 10 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(n3)]);
        char c0 = key[ix++];
        char c1 = key[ix++];
        char c2 = key[ix++];
        char c3 = key[ix++];
        int clients = LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(c0)]) * 1000 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(c1)]) * 100 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(c2)]) * 10 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(c3)]);
        char h0 = key[ix++];
        char h1 = key[ix++];
        char h2 = key[ix++];
        char h3 = key[ix++];
        char h4 = key[ix++];
        char h5 = key[ix++];
        char h6 = key[ix++];
        char h7 = key[ix++];
        int hdAmount = LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(h0)]) * 1000000 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(h1)]) * 1000000 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(h2)]) * 100000 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(h3)]) * 10000 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(h4)]) * 1000 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(h5)]) * 100 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(h6)]) * 10 + LicenseExtractorV2.ix1(key[LicenseExtractorV2.ix0(h7)]);
        License license = new License(0, licenseKey, null, null, cal.getTime(), isTrial, null, null, nodes, hdAmount, licenseType, 99, false, 0);
        license.setVersion(LicenseVersion.V2);
        LicenseHelper.mapFeaturesForLegacyLicense(license);
        return license;
    }

    private static int ix0(char c) {
        return LicenseExtractorV2.ix(LicenseHelper.chars, c);
    }

    private static int ix1(char c) {
        return LicenseExtractorV2.ix(LicenseHelper.digits, c);
    }

    private static int ix(char[] cc, char c) {
        for (int i = 0; i < cc.length; ++i) {
            if (c != cc[i]) continue;
            return i;
        }
        return -1;
    }
}

