/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.SnapshotValidationRecord;
import com.hazelcast.jet.impl.execution.BroadcastEntry;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.util.AsyncSnapshotWriterImpl;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class ExplodeSnapshotP
extends AbstractProcessor {
    private final Map<String, AbstractProcessor.FlatMapper<byte[], Object>> vertexToFlatMapper = new HashMap<String, AbstractProcessor.FlatMapper<byte[], Object>>();
    private final long expectedSnapshotId;
    private InternalSerializationService serializationService;

    ExplodeSnapshotP(Map<String, Integer> vertexToOrdinal, long expectedSnapshotId) {
        this.expectedSnapshotId = expectedSnapshotId;
        for (Map.Entry<String, Integer> en : vertexToOrdinal.entrySet()) {
            AbstractProcessor.FlatMapper oldValue = this.vertexToFlatMapper.put(en.getKey(), this.flatMapper(en.getValue(), this::traverser));
            assert (oldValue == null) : "Duplicate ordinal: " + en.getValue();
        }
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        this.serializationService = ((Contexts.ProcCtx)context).serializationService();
    }

    private Traverser<Object> traverser(byte[] data) {
        BufferObjectDataInput in = this.serializationService.createObjectDataInput(data);
        return () -> Util.uncheckCall(() -> {
            Object key = this.serializationService.readObject((ObjectDataInput)in, true);
            if (key == AsyncSnapshotWriterImpl.SnapshotDataValueTerminator.INSTANCE) {
                return null;
            }
            Object value = this.serializationService.readObject((ObjectDataInput)in, true);
            return key instanceof BroadcastKey ? new BroadcastEntry(key, value) : com.hazelcast.jet.Util.entry(key, value);
        });
    }

    @Override
    protected boolean tryProcess0(@Nonnull Object item) {
        if (((Map.Entry)item).getKey() instanceof SnapshotValidationRecord.SnapshotValidationKey) {
            return true;
        }
        Map.Entry castItem = (Map.Entry)item;
        String vertexName = ((AsyncSnapshotWriterImpl.SnapshotDataKey)castItem.getKey()).vertexName();
        AbstractProcessor.FlatMapper<byte[], Object> flatMapper = this.vertexToFlatMapper.get(vertexName);
        if (flatMapper == null) {
            if (!this.vertexToFlatMapper.containsKey(vertexName)) {
                this.vertexToFlatMapper.put(vertexName, null);
                this.getLogger().warning("Data for unknown vertex found in the snapshot, ignoring. Vertex=" + vertexName);
            }
            return true;
        }
        long snapshotId = ((AsyncSnapshotWriterImpl.SnapshotDataKey)castItem.getKey()).snapshotId();
        if (snapshotId != this.expectedSnapshotId) {
            this.getLogger().warning("Data for unexpected snapshot ID encountered, ignoring. Expected=" + this.expectedSnapshotId + ", found=" + snapshotId);
            return true;
        }
        return flatMapper.tryProcess((byte[])castItem.getValue());
    }
}

