/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.EnterpriseJobCoordinationService;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.operation.ExportSnapshotOperation;
import com.hazelcast.jet.impl.serialization.DelegatingEnterpriseSerializationService;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.util.LicenseHelper;
import com.hazelcast.security.impl.SecurityServiceImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EnterpriseJetServiceBackend
extends JetServiceBackend {
    private final Node node;

    public EnterpriseJetServiceBackend(Node node) {
        super(node);
        this.node = node;
    }

    @Override
    JobCoordinationService createJobCoordinationService() {
        return new EnterpriseJobCoordinationService(this.getNodeEngine(), this, this.getJetConfig(), this.getJobRepository());
    }

    @Override
    public EnterpriseJobCoordinationService getJobCoordinationService() {
        return (EnterpriseJobCoordinationService)super.getJobCoordinationService();
    }

    @Override
    public InternalSerializationService createSerializationService(Map<String, String> serializerConfigs) {
        return DelegatingEnterpriseSerializationService.from(this.getNodeEngine().getSerializationService(), serializerConfigs);
    }

    @Override
    public Operation createExportSnapshotOperation(long jobId, String name, boolean cancelJob) {
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.getNodeEngine().getNode().getNodeExtension();
        LicenseHelper.checkLicensePerFeature(nodeExtension.getLicense(), Feature.STREAMING_JOB_UPGRADES);
        return new ExportSnapshotOperation(jobId, name, cancelJob);
    }

    @Override
    public void configureJetInternalObjects(Config config, HazelcastProperties properties) {
        super.configureJetInternalObjects(config, properties);
        SecurityConfig securityConfig = config.getSecurityConfig();
        if (!securityConfig.isEnabled()) {
            return;
        }
        Set<PermissionConfig> clientPermissionConfigs = securityConfig.getClientPermissionConfigs();
        HashSet<PermissionConfig> dependingPermissionConfigs = new HashSet<PermissionConfig>();
        for (PermissionConfig clientPermissionConfig : clientPermissionConfigs) {
            String name = clientPermissionConfig.getName();
            if (name != null && name.startsWith("__jet.")) {
                throw new IllegalArgumentException("Explicitly configuring internal Jet data-structures is forbidden");
            }
            if (clientPermissionConfig.getType() != PermissionConfig.PermissionType.JOB) continue;
            if (this.hasAction(clientPermissionConfig, "submit")) {
                dependingPermissionConfigs.add(this.newFlakeIdGeneratorPermission(clientPermissionConfig));
            }
            if (this.hasAction(clientPermissionConfig, "add-resources")) {
                dependingPermissionConfigs.add(this.newResourcesPermission(clientPermissionConfig));
            }
            if (!this.hasAction(clientPermissionConfig, "export-snapshot")) continue;
            dependingPermissionConfigs.add(this.newSnapshotPermission(clientPermissionConfig));
        }
        clientPermissionConfigs.addAll(dependingPermissionConfigs);
        SecurityServiceImpl securityService = (SecurityServiceImpl)this.node.getSecurityService();
        securityService.setPermissionConfigs(SecurityServiceImpl.clonePermissionConfigs(clientPermissionConfigs));
    }

    private boolean hasAction(PermissionConfig clientPermissionConfig, String action) {
        Set<String> actions = clientPermissionConfig.getActions();
        return actions.contains(action) || actions.contains("all");
    }

    private PermissionConfig newFlakeIdGeneratorPermission(PermissionConfig clientPermissionConfig) {
        PermissionConfig permissionConfig = new PermissionConfig(PermissionConfig.PermissionType.FLAKE_ID_GENERATOR, "__jet.ids", clientPermissionConfig.getPrincipal());
        permissionConfig.setEndpoints(clientPermissionConfig.getEndpoints());
        permissionConfig.addAction("all");
        return permissionConfig;
    }

    private PermissionConfig newResourcesPermission(PermissionConfig clientPermissionConfig) {
        return this.newMapPermission(clientPermissionConfig, "resources*");
    }

    private PermissionConfig newSnapshotPermission(PermissionConfig clientPermissionConfig) {
        return this.newMapPermission(clientPermissionConfig, "exportedSnapshot*");
    }

    private PermissionConfig newMapPermission(PermissionConfig clientPermissionConfig, String prefix) {
        PermissionConfig permissionConfig = new PermissionConfig(PermissionConfig.PermissionType.MAP, "__jet." + prefix, clientPermissionConfig.getPrincipal());
        permissionConfig.setEndpoints(clientPermissionConfig.getEndpoints());
        permissionConfig.addAction("all");
        return permissionConfig;
    }
}

