/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.service.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.NativeMemoryConfig;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;

final class TieredStoreConfigValidator {
    private TieredStoreConfigValidator() {
    }

    static void validate(Config config) {
        TieredStoreConfigValidator.validateMemoryManagerConfig(config);
        TieredStoreConfigValidator.validateTieredStoreConfig(config);
        TieredStoreConfigValidator.validateLocalDevices(config);
        TieredStoreConfigValidator.validateMapStore(config);
        TieredStoreConfigValidator.validateMapDataPersistence(config);
        TieredStoreConfigValidator.validateMapInMemoryFormat(config);
    }

    private static void validateMemoryManagerConfig(Config config) {
        long nativeSize;
        NativeMemoryConfig nativeMemoryConfig = config.getNativeMemoryConfig();
        if (!nativeMemoryConfig.isEnabled()) {
            throw new InvalidConfigurationException("Native memory must be enabled to use tiered store");
        }
        long mapSize = config.getMapConfigs().values().stream().filter(m -> m.getTieredStoreConfig().isEnabled()).mapToLong(m -> m.getTieredStoreConfig().getMemoryTierConfig().getCapacity().bytes()).sum();
        if (mapSize > (nativeSize = config.getNativeMemoryConfig().getSize().bytes())) {
            throw new InvalidConfigurationException("Native memory size must be higher than sum of all memory tier size");
        }
    }

    private static void validateTieredStoreConfig(Config config) {
        config.getMapConfigs().values().stream().filter(c -> c.getTieredStoreConfig().isEnabled() && c.getTieredStoreConfig().getDiskTierConfig().isEnabled()).forEach(mapConfig -> {
            String mapName = mapConfig.getName();
            DiskTierConfig diskTierConfig = mapConfig.getTieredStoreConfig().getDiskTierConfig();
            String deviceName = diskTierConfig.getDeviceName();
            if (config.getDeviceConfig(deviceName) == null) {
                throw new InvalidConfigurationException(String.format("Map '%s' is configured for tiered storage, but there is no configuration found for the device '%s' to be used for the map", mapName, deviceName));
            }
        });
    }

    private static void validateLocalDevices(Config config) {
        config.getDeviceConfigs().values().forEach(TieredStoreConfigValidator::validateLocalDevice);
    }

    private static void validateLocalDevice(DeviceConfig deviceConfig) {
        assert (deviceConfig.isLocal());
        LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)deviceConfig;
        File baseDir = localDeviceConfig.getBaseDir();
        if (!baseDir.exists()) {
            DirectoryCheck directoryCheck = TieredStoreConfigValidator.canBeCreated(baseDir);
            if (directoryCheck.canBeCreated()) {
                return;
            }
            throw new InvalidConfigurationException(String.format("The configured base directory '%s' for the device '%s' does not exist and cannot be created. The last existing path is '%s' and it is read-only", baseDir.getAbsolutePath(), localDeviceConfig.getName(), directoryCheck.lastExistingDirectory()));
        }
        if (!baseDir.isDirectory()) {
            throw new InvalidConfigurationException(String.format("The configured base directory '%s' for the device '%s' is not a directory", baseDir.getAbsolutePath(), localDeviceConfig.getName()));
        }
        if (!baseDir.canRead()) {
            throw new InvalidConfigurationException(String.format("The configured base directory '%s' for the device '%s' is not readable", baseDir.getAbsolutePath(), localDeviceConfig.getName()));
        }
        if (!baseDir.canWrite()) {
            throw new InvalidConfigurationException(String.format("The configured base directory '%s' for the device '%s' is read-only", baseDir.getAbsolutePath(), localDeviceConfig.getName()));
        }
    }

    private static void validateMapStore(Config config) {
        config.getMapConfigs().values().stream().filter(c -> c.getTieredStoreConfig().isEnabled()).forEach(mapConfig -> {
            String mapName = mapConfig.getName();
            if (mapConfig.getMapStoreConfig().isEnabled()) {
                throw new InvalidConfigurationException(String.format("Map '%s' is configured for tiered storage, but map store is also configured. Tiered store and map store are mutually exclusive features.", mapName));
            }
        });
    }

    private static void validateMapDataPersistence(Config config) {
        config.getMapConfigs().values().stream().filter(c -> c.getTieredStoreConfig().isEnabled()).forEach(mapConfig -> {
            String mapName = mapConfig.getName();
            if (mapConfig.getDataPersistenceConfig().isEnabled()) {
                throw new InvalidConfigurationException(String.format("Map '%s' is configured for tiered storage, but data persistence is also configured. Tiered store and data persistence are mutually exclusive features.", mapName));
            }
        });
    }

    private static void validateMapInMemoryFormat(Config config) {
        config.getMapConfigs().values().stream().filter(c -> c.getTieredStoreConfig().isEnabled()).forEach(mapConfig -> {
            String mapName = mapConfig.getName();
            InMemoryFormat inMemoryFormat = mapConfig.getInMemoryFormat();
            if (inMemoryFormat != InMemoryFormat.NATIVE) {
                throw new InvalidConfigurationException(String.format("Map '%s' is configured for tiered storage, but '%s' in-memory format is set. Tiered store requires 'NATIVE' in-memory format", new Object[]{mapName, inMemoryFormat}));
            }
        });
    }

    private static DirectoryCheck canBeCreated(File baseDir) {
        Path completePath = Paths.get(baseDir.getAbsolutePath(), new String[0]);
        boolean stop = false;
        Path testedPath = completePath.getRoot();
        Iterator<Path> it = completePath.iterator();
        while (it.hasNext() && !stop) {
            stop = !(testedPath = testedPath.resolve(it.next())).toFile().exists();
        }
        return new DirectoryCheck(testedPath);
    }

    private static final class DirectoryCheck {
        private final Path lastTestedPath;

        private DirectoryCheck(Path lastTestedPath) {
            this.lastTestedPath = lastTestedPath;
        }

        private boolean canBeCreated() {
            return this.lastTestedPath.getParent().toFile().canWrite();
        }

        private String lastExistingDirectory() {
            return this.lastTestedPath.getParent().toString();
        }
    }
}

