/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.LogicalAddressSource;
import com.hazelcast.internal.tstore.hybridlog.TieredStoreWorkingSet;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.PagePinnedOffsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;

class TieredStoreWorkingSetImpl
implements TieredStoreWorkingSet {
    private final AtomicBoolean spinLock = new AtomicBoolean();
    private final HybridLogImpl log;
    private final AtomicReferenceArray<PagePinnedOffsets> pagePins;
    private boolean open = true;

    TieredStoreWorkingSetImpl(HybridLogImpl log) {
        this.log = Objects.requireNonNull(log);
        int capacity = log.pager.pagesCapacity;
        this.pagePins = new AtomicReferenceArray(capacity);
        for (int i = 0; i < capacity; ++i) {
            this.pagePins.set(i, new PagePinnedOffsets());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pin(long logicalAddress, BooleanSupplier pagePinStateCallback) {
        this.spinLock();
        try {
            PagePinnedOffsets pagePinnedOffsets = this.pagePins(logicalAddress);
            pagePinnedOffsets.pinOffset(this.log.pager.offset(logicalAddress));
            boolean pagePinnedAfter = pagePinnedOffsets.isAnyOffsetPinned();
            if (pagePinnedAfter) {
                boolean pageStatePinned = pagePinStateCallback.getAsBoolean();
                if (!pageStatePinned) {
                    pagePinnedOffsets.unpinOffset(this.log.pager.offset(logicalAddress));
                }
                boolean bl = pageStatePinned;
                return bl;
            }
            boolean bl = pagePinnedAfter;
            return bl;
        }
        finally {
            this.releaseSpinLock();
        }
    }

    @Override
    public boolean pin(LogicalAddressSource logicalAddressSource, BooleanSupplier pagePinStateCallback) {
        return this.pin(logicalAddressSource.getLogicalAddress(), pagePinStateCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpin(long logicalAddress, Runnable pageUnpinStateCallback) {
        this.spinLock();
        try {
            PagePinnedOffsets pagePinnedOffsets = this.pagePins(logicalAddress);
            if (-2 == pagePinnedOffsets.unpinOffset(this.log.pager.offset(logicalAddress))) {
                throw new IllegalArgumentException(String.format("%s - Logical address %s is not pinned and can't be unpinned.", this.log.debugHybridLogId(), this.log.pager.prettyFormat(logicalAddress)));
            }
            boolean pagePinnedAfter = pagePinnedOffsets.isAnyOffsetPinned();
            if (!pagePinnedAfter) {
                pageUnpinStateCallback.run();
            }
        }
        finally {
            this.releaseSpinLock();
        }
    }

    @Override
    public void unpin(LogicalAddressSource logicalAddressSource, Runnable pageUnpinStateCallback) {
        this.unpin(logicalAddressSource.getLogicalAddress(), pageUnpinStateCallback);
    }

    @Override
    public boolean isLogicalAddressPinned(LogicalAddressSource logicalAddressSource) {
        return this.isLogicalAddressPinned(logicalAddressSource.getLogicalAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLogicalAddressPinned(long logicalAddress) {
        this.spinLock();
        try {
            boolean bl = this.pagePins(logicalAddress).isOffsetPinned(this.log.pager.offset(logicalAddress));
            return bl;
        }
        finally {
            this.releaseSpinLock();
        }
    }

    @Override
    public void close() throws Exception {
        this.spinLock();
        try {
            this.closeInternal();
        }
        finally {
            this.releaseSpinLock();
        }
    }

    boolean isPagePinned(int page) {
        this.spinLock();
        try {
            boolean bl = this.pagePins.get(this.log.pager.pageIndex(page)).isAnyOffsetPinned();
            return bl;
        }
        finally {
            this.releaseSpinLock();
        }
    }

    private void closeInternal() {
        this.open = false;
    }

    private PagePinnedOffsets pagePins(long logicalAddress) {
        int page = this.log.pager.page(logicalAddress);
        int pageIndex = this.log.pager.pageIndex(page);
        PagePinnedOffsets pinned = this.pagePins.get(pageIndex);
        if (pinned == null) {
            pinned = new PagePinnedOffsets();
            this.pagePins.set(pageIndex, pinned);
        }
        return pinned;
    }

    private void spinLock() {
        while (this.open && !this.spinLock.compareAndSet(false, true)) {
            Thread.yield();
        }
        if (!this.open) {
            throw new IllegalStateException("The working set is closed");
        }
    }

    private void releaseSpinLock() {
        this.spinLock.set(false);
    }
}

