/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntFunction;

class PageStateMachine {
    private static final Runnable NOP_UNDO_ACTION = () -> {};
    final int capacity;
    private final AtomicReferenceArray<PageState> pageStates;
    private final ILogger logger = Logger.getLogger(PageStateMachine.class);
    private final String hybridLogId;
    private final IntFunction<String> pageInfoFormatterFn;

    PageStateMachine(String hybridLogId, int capacity) {
        this(hybridLogId, capacity, Integer::toString);
    }

    PageStateMachine(String hybridLogId, int capacity, IntFunction<String> pageInfoFormatterFunction) {
        this.hybridLogId = hybridLogId;
        this.capacity = capacity;
        this.pageStates = new AtomicReferenceArray(capacity);
        this.pageInfoFormatterFn = pageInfoFormatterFunction;
        for (int i = 0; i < capacity; ++i) {
            this.pageStates.set(i, PageState.NOT_BACKED);
        }
    }

    boolean assign(int page, int pageIndex, Action prepareAction, Runnable undoAction) {
        if (!this.tryChangePageState(page, pageIndex, PageState.PREPARING)) {
            return false;
        }
        try {
            if (!prepareAction.run()) {
                this.undo(pageIndex, PageState.NOT_BACKED, undoAction);
                return false;
            }
            this.changePageState(page, pageIndex, PageState.READY);
        }
        catch (Exception ex) {
            this.undo(pageIndex, PageState.NOT_BACKED, undoAction);
            throw ex;
        }
        return true;
    }

    boolean activate(int page, int pageIndex) {
        if (!this.tryChangePageState(page, pageIndex, PageState.ACTIVATING)) {
            return false;
        }
        try {
            this.changePageState(page, pageIndex, PageState.ACTIVE);
        }
        catch (Exception ex) {
            this.undo(pageIndex, PageState.READY, NOP_UNDO_ACTION);
            throw ex;
        }
        return true;
    }

    boolean readonly(int page, int pageIndex) {
        return this.tryChangePageState(page, pageIndex, PageState.READONLY, true);
    }

    void flush(int page, int pageIndex) {
        this.changePageState(page, pageIndex, PageState.FLUSHING);
    }

    void flushed(int page, int pageIndex) {
        this.changePageState(page, pageIndex, PageState.FLUSHED);
    }

    boolean releasable(int page, int pageIndex) {
        return this.pageState(pageIndex) == PageState.FLUSHED && this.tryChangePageState(page, pageIndex, PageState.RELEASABLE);
    }

    boolean release(int page, int pageIndex, Runnable releaseAction) {
        if (!this.tryChangePageState(page, pageIndex, PageState.RELEASING)) {
            return false;
        }
        try {
            releaseAction.run();
            this.changePageState(page, pageIndex, PageState.NOT_BACKED);
        }
        catch (Exception ex) {
            this.undo(pageIndex, PageState.NOT_BACKED, NOP_UNDO_ACTION);
            throw ex;
        }
        return true;
    }

    PinSuccessState pinPageForUpdate(int page, int pageIndex) {
        PageState currentPageState = this.pageState(pageIndex);
        if (currentPageState == PageState.PINNED_FOR_UPDATE) {
            return PinSuccessState.STAY_PINNED;
        }
        return this.tryChangePageState(page, pageIndex, PageState.PINNED_FOR_UPDATE) ? PinSuccessState.PINNED : PinSuccessState.UNSUCCESSFUL;
    }

    PinSuccessState pinPage(int page, int pageIndex) {
        PageState pinVariantPageState;
        PageState currentPageState;
        do {
            currentPageState = this.pageState(pageIndex);
            pinVariantPageState = currentPageState.pinVariantState();
        } while (!currentPageState.isPinnedState() && pinVariantPageState != null && !this.tryChangePageState(page, pageIndex, pinVariantPageState));
        if (currentPageState.isPinnedState()) {
            return PinSuccessState.STAY_PINNED;
        }
        return pinVariantPageState != null ? PinSuccessState.PINNED : PinSuccessState.UNSUCCESSFUL;
    }

    boolean unpinPage(int page, int pageIndex) {
        PageState pinVariantState;
        PageState currentPageState;
        do {
            currentPageState = this.pageState(pageIndex);
            pinVariantState = currentPageState.pinVariantState();
        } while (currentPageState.isPinnedState() && !this.tryChangePageState(page, pageIndex, pinVariantState));
        return !currentPageState.isPinnedState() || pinVariantState != null;
    }

    PageState pageState(int pageIndex) {
        return this.pageStates.get(pageIndex);
    }

    void forceSetNotBacked(int pageIndex) {
        this.pageStates.set(pageIndex, PageState.NOT_BACKED);
    }

    private void forceSetPageState(int pageIndex, PageState state) {
        this.pageStates.set(pageIndex, state);
    }

    private void undo(int pageIndex, PageState fallbackState, Runnable undoAction) {
        undoAction.run();
        this.forceSetPageState(pageIndex, fallbackState);
    }

    private void changePageState(int page, int pageIndex, PageState targetState) {
        PageState currentState;
        do {
            if ((currentState = this.pageState(pageIndex)).isSyncState()) {
                Thread.yield();
                continue;
            }
            targetState = this.chooseTargetVariantState(currentState, targetState);
            PageState[] allowedPreviousStates = targetState.allowedPreviousStates();
            boolean validStateChange = false;
            for (int i = 0; i < allowedPreviousStates.length && !validStateChange; ++i) {
                validStateChange = currentState == allowedPreviousStates[i];
            }
            if (validStateChange) continue;
            this.throwOnInvalidStateChange(page, currentState, targetState);
        } while (!this.pageStates.compareAndSet(pageIndex, currentState, targetState));
        this.logPageStateTransition(page, currentState, targetState);
    }

    private boolean tryChangePageState(int page, int pageIndex, PageState targetState) {
        return this.tryChangePageState(page, pageIndex, targetState, false);
    }

    private boolean tryChangePageState(int page, int pageIndex, PageState targetState, boolean followPinnedPath) {
        PageState currentState;
        boolean retry;
        do {
            if ((currentState = this.pageState(pageIndex)).isPinnedState() && followPinnedPath && !targetState.isPinnedState() && targetState.pinVariantState != null) {
                targetState = targetState.pinVariantState;
            }
            retry = false;
            if (currentState == targetState) {
                return false;
            }
            if (currentState.isSyncState()) {
                Thread.yield();
                retry = true;
                continue;
            }
            PageState[] allowedPreviousStates = targetState.allowedPreviousStates();
            boolean validStateChange = false;
            for (int i = 0; i < allowedPreviousStates.length && !validStateChange; ++i) {
                validStateChange = currentState == allowedPreviousStates[i];
            }
            if (validStateChange) continue;
            return false;
        } while (retry || !this.pageStates.compareAndSet(pageIndex, currentState, targetState));
        this.logPageStateTransition(page, currentState, targetState);
        return true;
    }

    private PageState chooseTargetVariantState(PageState currentState, PageState targetState) {
        if (currentState.isPinnedState() && targetState.isPinnedState() || !currentState.isPinnedState() && !targetState.isPinnedState()) {
            return targetState;
        }
        return targetState.pinVariantState();
    }

    void throwOnInvalidStateChange(int page, PageState currentState, PageState targetState) {
        throw new IllegalStateException(String.format("%s - State transition %s -> %s for %s is not valid", TStoreUtil.hybridLogStr(this.hybridLogId), currentState.name(), targetState.name(), this.pageInfoFormatterFn.apply(page)));
    }

    private void logPageStateTransition(int page, PageState sourceState, PageState targetState) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine(String.format("%s - Changed state for %s: %s -> %s", new Object[]{TStoreUtil.hybridLogStr(this.hybridLogId), this.pageInfoFormatterFn.apply(page), sourceState, targetState}));
        }
    }

    static enum PinSuccessState {
        PINNED(true),
        STAY_PINNED(true),
        UNSUCCESSFUL(false);

        private final boolean endsInPinnedPage;

        private PinSuccessState(boolean endsInPinnedPage) {
            this.endsInPinnedPage = endsInPinnedPage;
        }

        boolean endsInPinnedPage() {
            return this.endsInPinnedPage;
        }
    }

    @FunctionalInterface
    static interface Action {
        public boolean run();
    }

    static enum PageState {
        NOT_BACKED,
        PREPARING,
        READY,
        ACTIVATING,
        ACTIVE,
        READONLY,
        FLUSHING,
        FLUSHED,
        PINNED_ACTIVE,
        PINNED_READONLY,
        PINNED_FLUSHING,
        PINNED_FLUSHED,
        PINNED_FOR_UPDATE,
        RELEASABLE,
        RELEASING;

        private PageState[] allowedPreviousStates;
        private PageState pinVariantState;
        private final boolean pinnedState = this.name().startsWith("PINNED_");
        private boolean syncState;
        private PageState syncFor;

        PageState[] allowedPreviousStates() {
            return this.allowedPreviousStates;
        }

        boolean isPinnedState() {
            return this.pinnedState;
        }

        public boolean isSyncState() {
            return this.syncState;
        }

        PageState pinVariantState() {
            return this.pinVariantState;
        }

        static {
            PageState.NOT_BACKED.allowedPreviousStates = new PageState[]{RELEASING};
            PageState.PREPARING.allowedPreviousStates = new PageState[]{NOT_BACKED};
            PageState.READY.allowedPreviousStates = new PageState[]{PREPARING};
            PageState.ACTIVATING.allowedPreviousStates = new PageState[]{READY};
            PageState.ACTIVE.allowedPreviousStates = new PageState[]{ACTIVATING, PINNED_ACTIVE, PINNED_FOR_UPDATE};
            PageState.READONLY.allowedPreviousStates = new PageState[]{ACTIVE, PINNED_READONLY};
            PageState.FLUSHING.allowedPreviousStates = new PageState[]{READONLY, PINNED_FLUSHING};
            PageState.FLUSHED.allowedPreviousStates = new PageState[]{FLUSHING, PINNED_FLUSHED};
            PageState.RELEASABLE.allowedPreviousStates = new PageState[]{FLUSHED};
            PageState.RELEASING.allowedPreviousStates = new PageState[]{RELEASABLE};
            PageState.PINNED_ACTIVE.allowedPreviousStates = new PageState[]{ACTIVE};
            PageState.PINNED_READONLY.allowedPreviousStates = new PageState[]{READONLY, PINNED_ACTIVE};
            PageState.PINNED_FLUSHING.allowedPreviousStates = new PageState[]{FLUSHING, PINNED_READONLY};
            PageState.PINNED_FLUSHED.allowedPreviousStates = new PageState[]{FLUSHED, PINNED_FLUSHING};
            PageState.PINNED_FOR_UPDATE.allowedPreviousStates = new PageState[]{ACTIVE, PINNED_ACTIVE};
            PageState.ACTIVE.pinVariantState = PINNED_ACTIVE;
            PageState.READONLY.pinVariantState = PINNED_READONLY;
            PageState.FLUSHING.pinVariantState = PINNED_FLUSHING;
            PageState.FLUSHED.pinVariantState = PINNED_FLUSHED;
            PageState.PINNED_ACTIVE.pinVariantState = ACTIVE;
            PageState.PINNED_FOR_UPDATE.pinVariantState = ACTIVE;
            PageState.PINNED_READONLY.pinVariantState = READONLY;
            PageState.PINNED_FLUSHING.pinVariantState = FLUSHING;
            PageState.PINNED_FLUSHED.pinVariantState = FLUSHED;
            PageState.PREPARING.syncState = true;
            PageState.PREPARING.syncFor = READY;
            PageState.ACTIVATING.syncState = true;
            PageState.RELEASING.syncState = true;
        }
    }
}

