/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.util.QuickMath;
import java.util.Arrays;

class PagePinnedOffsets {
    static final int NOT_PINNED_OFFSET = -2;
    private static final int EMPTY = -1;
    private static final int DEFAULT_INITIAL_CAPACITY = 4;
    private static final float DEFAULT_LOAD_FACTOR = 0.8f;
    private final float loadFactor;
    private int[] table;
    private int resizeThreshold;
    private int capacity = QuickMath.nextPowerOfTwo(4);
    private int mask;
    private int size;

    PagePinnedOffsets() {
        this.loadFactor = 0.8f;
        this.resizeThreshold = (int)((float)this.capacity * this.loadFactor);
        this.mask = 2 * this.capacity - 1;
        this.table = new int[2 * this.capacity];
        Arrays.fill(this.table, -1);
    }

    void pinOffset(int offset) {
        int hash = Integer.hashCode(offset);
        int index = this.hash2Index(hash);
        while (this.table[index] != -1) {
            if (offset == this.table[index]) {
                int n = index + 1;
                this.table[n] = this.table[n] + 1;
                return;
            }
            index = this.nextIndex(index);
        }
        ++this.size;
        this.table[index] = offset;
        this.table[index + 1] = 1;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
    }

    int unpinOffset(int offset) {
        int hash = Integer.hashCode(offset);
        int index = this.hash2Index(hash);
        while (this.table[index] != -1) {
            if (offset == this.table[index]) {
                int n = index + 1;
                this.table[n] = this.table[n] - 1;
                int newCounter = this.table[n];
                if (newCounter != 0) {
                    return newCounter;
                }
                this.table[index] = -1;
                this.compactChain(index);
                --this.size;
                return 0;
            }
            index = this.nextIndex(index);
        }
        return -2;
    }

    boolean isOffsetPinned(int offset) {
        int hash = Integer.hashCode(offset);
        int index = this.hash2Index(hash);
        while (this.table[index] != -1) {
            if (offset == this.table[index]) {
                return true;
            }
            index = this.nextIndex(index);
        }
        return false;
    }

    boolean isAnyOffsetPinned() {
        return this.size > 0;
    }

    void clear() {
        this.size = 0;
        Arrays.fill(this.table, -1);
    }

    private void increaseCapacity() {
        int newCapacity = this.capacity << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        this.capacity = newCapacity;
        this.mask = 2 * this.capacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        int[] newTable = new int[2 * this.capacity];
        Arrays.fill(newTable, -1);
        for (int i = 0; i < this.table.length; i += 2) {
            int offset = this.table[i];
            int counter = this.table[i + 1];
            if (offset == -1) continue;
            int hash = Integer.hashCode(offset);
            int index = this.hash2Index(hash);
            while (newTable[index] != -1) {
                index = this.nextIndex(index);
            }
            newTable[index] = offset;
            newTable[index + 1] = counter;
        }
        this.table = newTable;
    }

    private void compactChain(int indexOfRemoved) {
        int deleteIndex;
        int index = deleteIndex = indexOfRemoved;
        while (this.table[index = this.nextIndex(index)] != -1) {
            int offset = this.table[index];
            int hash = Integer.hashCode(offset);
            int hashedIndex = this.hash2Index(hash);
            if ((index >= hashedIndex || hashedIndex > deleteIndex && deleteIndex > index) && (hashedIndex > deleteIndex || deleteIndex > index)) continue;
            this.table[deleteIndex] = this.table[index];
            this.table[deleteIndex + 1] = this.table[index + 1];
            this.table[index] = -1;
            this.table[index + 1] = -1;
            deleteIndex = index;
        }
        return;
    }

    private int nextIndex(int index) {
        return index + 2 & this.mask;
    }

    private int hash2Index(int hash) {
        return 2 * hash & this.mask;
    }
}

