/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAddressTranslator;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorType;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.PageHeaderSupport;
import com.hazelcast.internal.tstore.hybridlog.impl.Pager;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.MemoryUnit;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LogBasedHybridLogIterator<P, E>
implements Iterator<E> {
    private static final int UNINITIALIZED = -1;
    private final HybridLogImpl log;
    private final HybridLogAccessor logAccessor;
    private final Pager pager;
    private final InMemorySlotAccessor<P, E> slotAccessor;
    private final HybridLogIteratorType type;
    private final long startLogicalAddress;
    private final long endLogicalAddress;
    private int threadIndex = -1;
    private final IdleStrategy idleStrategy = new BackoffIdleStrategy(1000L, 100L, 100L, 10000L);
    private final ILogger logger;
    private long nextLogicalAddress;
    private E nextElement;
    private final LogBasedHybridLogIteratorMetrics metrics;

    public LogBasedHybridLogIterator(HybridLogImpl log, long startLogicalAddress, InMemorySlotAccessor<P, E> slotAccessor, HybridLogIteratorType type) {
        this(log, startLogicalAddress, log.lastAllocatedAddress(), slotAccessor, type);
    }

    public LogBasedHybridLogIterator(HybridLogImpl log, long startLogicalAddress, long endLogicalAddress, InMemorySlotAccessor<P, E> slotAccessor, HybridLogIteratorType type) {
        this.log = log;
        this.logAccessor = new HybridLogAccessor(log);
        this.pager = log.pager;
        this.type = type;
        this.slotAccessor = slotAccessor;
        this.startLogicalAddress = startLogicalAddress;
        this.nextLogicalAddress = -1L;
        this.endLogicalAddress = endLogicalAddress;
        this.logger = Logger.getLogger("TStore:HLog:Iterator");
        this.metrics = new LogBasedHybridLogIteratorMetrics(this.pager.pageSize);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Created iterator with nextLogicalAddress=" + this.pager.prettyFormat(this.nextLogicalAddress) + " and endLogicalAddress=" + this.pager.prettyFormat(endLogicalAddress));
        }
    }

    public void init() {
        this.threadIndex = this.log.epoch.getCurrentThreadIndex();
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement == null && this.nextLogicalAddress != 0L) {
            this.advanceToNextSlot();
        }
        return this.nextElement != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No element at " + this.pager.prettyFormat(this.nextLogicalAddress));
        }
        E returnElement = this.nextElement;
        this.nextElement = null;
        return returnElement;
    }

    public void close() {
        this.logAccessor.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void advanceToNextSlot() {
        boolean isWithinRange;
        boolean isAlive;
        long nextSlotLogicalAddress = this.nextLogicalAddress;
        do {
            boolean bl = isWithinRange = (nextSlotLogicalAddress = this.calculateNextLogicalAddress(nextSlotLogicalAddress)) <= this.endLogicalAddress();
            if (!isWithinRange) break;
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Trying " + this.pager.prettyFormat(nextSlotLogicalAddress));
            }
            P nextPreparedSlot = this.slotAccessor.prepare(nextSlotLogicalAddress, this.logAccessor);
            this.lockEntry(nextPreparedSlot);
            try {
                isAlive = this.slotAccessor.isAlive(nextPreparedSlot);
                if (!isAlive) continue;
                this.nextLogicalAddress = nextSlotLogicalAddress;
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Using " + this.pager.prettyFormat(nextSlotLogicalAddress));
                }
                this.nextElement = this.slotAccessor.asEntry(nextPreparedSlot);
            }
            finally {
                this.slotAccessor.unlock(nextPreparedSlot);
            }
        } while (!isAlive);
        if (!isWithinRange) {
            this.close();
        }
    }

    private long calculateNextLogicalAddress(long nextLogicalAddress) {
        if (nextLogicalAddress > this.endLogicalAddress()) {
            return nextLogicalAddress;
        }
        if (nextLogicalAddress == -1L) {
            return this.startLogicalAddress;
        }
        int currentPage = this.pager.page(nextLogicalAddress);
        long nextPageHeaderAddress = this.logAccessor.pageAddress(currentPage);
        int lastPageAllocatedOffset = PageHeaderSupport.readLastAllocatedOffset(nextPageHeaderAddress);
        int currentOffset = this.pager.offset(nextLogicalAddress);
        if (currentOffset < lastPageAllocatedOffset) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Taking " + this.pager.prettyFormat(nextLogicalAddress));
            }
            P slot = this.slotAccessor.prepare(nextLogicalAddress, this.logAccessor);
            int slotSize = this.slotAccessor.size(slot);
            return this.log.align(nextLogicalAddress + (long)slotSize);
        }
        if (currentOffset == lastPageAllocatedOffset) {
            this.refreshEpoch();
            int nextPage = currentPage + 1;
            return this.pager.asLogicalAddress(nextPage, 8);
        }
        throw new IllegalStateException(String.format("Trying to iterate over %s. The last offset of the page is %d", this.pager.prettyFormat(this.pager.asLogicalAddress(currentPage, currentOffset)), lastPageAllocatedOffset));
    }

    private void refreshEpoch() {
        this.log.epoch.refresh(this.threadIndex);
    }

    private long endLogicalAddress() {
        return this.type == HybridLogIteratorType.BOUNDED ? this.endLogicalAddress : this.log.lastAllocatedAddress();
    }

    private void lockEntry(P preparedSlot) {
        long idleCount = 0L;
        while (!this.slotAccessor.lock(preparedSlot)) {
            this.idleStrategy.idle(idleCount++);
        }
    }

    public String toString() {
        return "LogBasedHybridLogIterator{type=" + (Object)((Object)this.type) + ", startLogicalAddress=" + this.pager.prettyFormat(this.startLogicalAddress) + ", nextLogicalAddress=" + this.pager.prettyFormat(this.nextLogicalAddress) + ", endLogicalAddress=" + this.pager.prettyFormat(this.endLogicalAddress()) + ", nextElement=" + this.nextElement + ", slotAccessor=" + this.slotAccessor + '}';
    }

    public String readableMetrics() {
        return this.metrics.readableMetrics();
    }

    private static class LogBasedHybridLogIteratorMetrics {
        long ioTimeNanos;
        int pagesReadFromDiskCnt;
        private final int pageSizeBytes;

        LogBasedHybridLogIteratorMetrics(int pageSizeBytes) {
            this.pageSizeBytes = pageSizeBytes;
        }

        void onReadPageFromDisk() {
            ++this.pagesReadFromDiskCnt;
        }

        void onIOTimeReadPageFromDisk(long nanos) {
            this.ioTimeNanos += nanos;
        }

        String readableMetrics() {
            String newLine = System.lineSeparator() + "\t";
            return System.lineSeparator() + "LogBasedHybridLogIteratorMetrics:" + newLine + "pagesReadFromDiskCnt=" + this.pagesReadFromDiskCnt + newLine + "pageSize=" + MemoryUnit.BYTES.toMegaBytes(this.pageSizeBytes) + " MB" + newLine + "totalDataIteratedOver=" + MemoryUnit.BYTES.toMegaBytes((long)this.pageSizeBytes * (long)this.pagesReadFromDiskCnt) + " MB" + newLine + "pageReadsIOTime=" + String.format("%.3f", (double)this.ioTimeNanos / 1000000.0) + " millis.";
        }
    }

    @NotThreadSafe
    private final class HybridLogAccessor
    implements MemoryAddressTranslator {
        private byte[] fetchBuffer;
        private final HybridLogImpl log;
        private int cachedPage = -1;
        private long cachePagePhysicalAddress;

        private HybridLogAccessor(HybridLogImpl log) {
            this.log = log;
        }

        @Override
        public boolean isInMemory(long logicalAddress) {
            return true;
        }

        @Override
        public long asPhysicalAddress(long logicalAddress) {
            if (this.log.isInMemory(logicalAddress)) {
                return this.log.asPhysicalAddress(logicalAddress);
            }
            int page = LogBasedHybridLogIterator.this.pager.page(logicalAddress);
            int offset = LogBasedHybridLogIterator.this.pager.offset(logicalAddress);
            long cachedAddress = this.cachePagePhysicalAddress();
            if (page == this.cachedPage) {
                return cachedAddress + (long)offset;
            }
            this.cachedPage = page;
            byte[] buffer = this.fetchBuffer();
            long now = LogBasedHybridLogIterator.this.logger.isFineEnabled() ? System.nanoTime() : 0L;
            this.log.fetchPage(page, buffer);
            if (LogBasedHybridLogIterator.this.logger.isFineEnabled()) {
                LogBasedHybridLogIterator.this.metrics.onReadPageFromDisk();
                LogBasedHybridLogIterator.this.metrics.onIOTimeReadPageFromDisk(System.nanoTime() - now);
            }
            GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray(buffer, 0, cachedAddress, buffer.length);
            if (LogBasedHybridLogIterator.this.logger.isFineEnabled()) {
                long pageAddress = LogBasedHybridLogIterator.this.pager.asLogicalAddress(page, 0);
                LogBasedHybridLogIterator.this.logger.fine(String.format("Cached page %d with logical address %s and last allocated address %s at %s", page, LogBasedHybridLogIterator.this.pager.prettyFormat(pageAddress), LogBasedHybridLogIterator.this.pager.prettyFormat(LogBasedHybridLogIterator.this.pager.asLogicalAddress(page, PageHeaderSupport.readLastAllocatedOffset(this.cachePagePhysicalAddress))), TStoreUtil.prettyFormatPhysical(cachedAddress)));
            }
            return cachedAddress + (long)offset;
        }

        private byte[] fetchBuffer() {
            if (this.fetchBuffer == null) {
                this.fetchBuffer = new byte[((LogBasedHybridLogIterator)LogBasedHybridLogIterator.this).pager.pageSize];
            }
            return this.fetchBuffer;
        }

        private long cachePagePhysicalAddress() {
            if (this.cachePagePhysicalAddress == 0L) {
                this.cachePagePhysicalAddress = this.log.pagePool.acquire();
                if (LogBasedHybridLogIterator.this.logger.isFineEnabled()) {
                    LogBasedHybridLogIterator.this.logger.fine("Allocated iterator page cache at " + TStoreUtil.prettyFormatPhysical(this.cachePagePhysicalAddress));
                }
            }
            return this.cachePagePhysicalAddress;
        }

        private void release() {
            if (this.cachePagePhysicalAddress != 0L) {
                this.log.pagePool.release(this.cachePagePhysicalAddress);
                if (LogBasedHybridLogIterator.this.logger.isFineEnabled()) {
                    LogBasedHybridLogIterator.this.logger.fine("Freed iterator page cache at " + TStoreUtil.prettyFormatPhysical(this.cachePagePhysicalAddress));
                }
                this.cachePagePhysicalAddress = 0L;
            }
        }

        public long pageAddress(int page) {
            return page == this.cachedPage ? this.cachePagePhysicalAddress : LogBasedHybridLogIterator.this.pager.pageAddress(page);
        }
    }
}

