/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.IncrementalCompactor;
import com.hazelcast.internal.tstore.compaction.InterruptableCompactor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorType;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.LogBasedHybridLogIterator;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.TieredStoreSlotAccessor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LogBasedHLogCompactor
extends InterruptableCompactor<TieredStoreRecord>
implements IncrementalCompactor {
    private static final int UNINITIALIZED = -1;
    private static final ILogger LOGGER = Logger.getLogger(LogBasedHLogCompactor.class);
    private final LogBasedHybridLogIterator<TieredStoreRecord, TieredStoreRecord> logIterator;
    private final TieredStoreSlotAccessor slotAccessor;
    private final AddressRemapper<TieredStoreRecord> addressRemapper = new AddressRemapperImpl();
    private final HybridLogImpl log;
    private final TieredStoreRecordAccessor recordAccessor;
    private final HybridLogCompactorMetrics metrics = new HybridLogCompactorMetrics();
    private final Device device;
    private final Index index;
    private final State state;
    private final Epoch epoch;
    private final int segmentNo;
    private int threadIndex = -1;

    public LogBasedHLogCompactor(TieredStoreRecordAccessor recordAccessor, HybridLogImpl hybridLog, Index index, State state, Epoch epoch, int segmentNo) {
        super(hybridLog.getDevice());
        Invariants.nonNegative(segmentNo);
        this.log = hybridLog;
        this.device = this.log.getDevice();
        this.segmentNo = segmentNo;
        long fromLogicalAddress = this.log.firstEntry(segmentNo);
        long toLogicalAddressInclusive = this.device.segmentLastLogicalAddress(segmentNo);
        this.recordAccessor = recordAccessor;
        this.slotAccessor = new InMemorySlotAccessorImpl(recordAccessor);
        this.logIterator = new LogBasedHybridLogIterator<TieredStoreRecord, TieredStoreRecord>(this.log, fromLogicalAddress, toLogicalAddressInclusive, this.slotAccessor, HybridLogIteratorType.BOUNDED);
        this.index = index;
        this.state = state;
        this.epoch = epoch;
    }

    private void compact(TieredStoreRecord entry) {
        long logicalRecord;
        if (this.recordAccessor.isDummy(entry)) {
            if (LOGGER.isFineEnabled()) {
                this.metrics.onVisitedDummyRecord();
                this.metrics.onVisitedRecordIsNotIndexReachable();
            }
            return;
        }
        if (LOGGER.isFineEnabled()) {
            this.metrics.onVisitedNonDummyRecord();
        }
        Data entryKey = entry.getKey();
        long entryLogicalAddress = entry.getLogicalAddress();
        assert (entryKey != null);
        while (-1L == (logicalRecord = this.index.getRaw(this.threadIndex, entryKey, entryLogicalAddress, true))) {
            Thread.yield();
            this.refreshEpochAndState();
        }
        if (logicalRecord > 0L) {
            if (LOGGER.isFineEnabled()) {
                this.metrics.onVisitedIndexReachableRecord();
            }
            return;
        }
        if (!this.isReachable(logicalRecord = -logicalRecord, entryLogicalAddress)) {
            if (LOGGER.isFineEnabled()) {
                this.metrics.onVisitedRecordIsNotIndexReachable();
            }
            return;
        }
        TieredStoreRecord r = this.log.readRecordForReadOnly(entryLogicalAddress, this.slotAccessor, this.addressRemapper);
        assert (r != null);
        if (LOGGER.isFineEnabled()) {
            this.metrics.onVisitedIndexReachableRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReachable(long logicalRecord, long dstLogicalRecord) {
        int ioCnt = 0;
        long ioTimeNanos = 0L;
        while (logicalRecord != 0L && logicalRecord != dstLogicalRecord) {
            byte[] record;
            if (this.log.isInMemory(logicalRecord)) {
                logicalRecord = TieredStoreRecordAccessor.getNextRecordAddress(this.log.asPhysicalAddress(logicalRecord));
                this.refreshEpochAndState();
                continue;
            }
            long now = LOGGER.isFineEnabled() ? System.nanoTime() : 0L;
            int recordSegmentNo = this.device.segmentNoOf(logicalRecord);
            if (!this.device.tryReadLock(recordSegmentNo)) break;
            try {
                record = this.device.readRecord(logicalRecord, this.slotAccessor);
            }
            finally {
                this.device.releaseReadLock(recordSegmentNo);
            }
            if (LOGGER.isFineEnabled()) {
                ioTimeNanos += System.nanoTime() - now;
                ++ioCnt;
            }
            logicalRecord = TieredStoreRecordAccessor.getNextRecordAddress(record);
            this.refreshEpochAndState();
        }
        if (LOGGER.isFineEnabled()) {
            this.metrics.onIOForRecordReachability(ioCnt);
            this.metrics.onIOTimeToCheckIndexReachability(ioTimeNanos);
        }
        return logicalRecord == dstLogicalRecord;
    }

    @Override
    public void init() {
    }

    @Override
    public void compact() {
        this.onCompactionStart();
        try {
            this.threadIndex = this.epoch.register();
            this.state.register(this.threadIndex);
            this.logIterator.init();
            while (this.hasNext()) {
                this.checkInterrupted();
                this.compact(this.next());
            }
            this.refreshEpochAndState();
            this.device.truncateAsync(this.segmentNo);
        }
        catch (Throwable ex) {
            this.onCompactionFinish(ex);
            throw ex;
        }
        finally {
            this.state.unregister(this.threadIndex);
            this.epoch.unregister(this.threadIndex);
            this.logIterator.close();
        }
        this.onCompactionFinish(null);
    }

    private void onCompactionStart() {
        if (LOGGER.isFineEnabled()) {
            LOGGER.fine("starting with compaction on HybridLog with id=" + this.log.getId() + ", segmentNo=" + this.segmentNo);
            this.metrics.onStart();
        }
    }

    private void onCompactionFinish(@Nullable Throwable ex) {
        this.deregister();
        if (ex != null) {
            LOGGER.warning(this.toReadableStr(ex));
        }
        if (LOGGER.isFineEnabled()) {
            this.metrics.onFinish();
            LOGGER.fine(this.metrics.readableMetrics());
            LOGGER.fine(this.logIterator.readableMetrics());
            LOGGER.fine("done with compaction on HybridLog with id=" + this.log.getId() + ", segmentNo=" + this.segmentNo);
        }
    }

    @Override
    public void after() {
    }

    private boolean hasNext() {
        return this.logIterator.hasNext();
    }

    private TieredStoreRecord next() {
        return this.logIterator.next();
    }

    private void refreshEpochAndState() {
        this.epoch.refresh(this.threadIndex);
        this.state.refresh(this.threadIndex);
    }

    private String toReadableStr(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        String ln = System.lineSeparator();
        StringBuilder sb = new StringBuilder().append("Exception during compaction of HybridLog with id=").append(this.log.getId()).append(", and fileNo=").append(this.segmentNo).append(ln).append(throwable.getMessage()).append(ln);
        for (StackTraceElement e : throwable.getStackTrace()) {
            sb.append(e.toString()).append(ln);
        }
        return sb.toString();
    }

    private static class HybridLogCompactorMetrics {
        long dummyRecordsCnt;
        long nonDummyRecordsCnt;
        long aliveRecordsCnt;
        long deadRecordsCnt;
        long startTimeMillis = -1L;
        long finishTimeMillis = -1L;
        long ioTimeToCheckIndexReachabilityNanos;
        long[] ioCntToCheckIndexReachability = new long[10];
        long ioCntMoreThan10ToCheckIndexReachability;

        private HybridLogCompactorMetrics() {
        }

        void onStart() {
            this.startTimeMillis = System.currentTimeMillis();
        }

        void onFinish() {
            this.finishTimeMillis = System.currentTimeMillis();
        }

        void onVisitedDummyRecord() {
            ++this.dummyRecordsCnt;
        }

        void onVisitedNonDummyRecord() {
            ++this.nonDummyRecordsCnt;
        }

        void onVisitedIndexReachableRecord() {
            ++this.aliveRecordsCnt;
        }

        void onVisitedRecordIsNotIndexReachable() {
            ++this.deadRecordsCnt;
        }

        void onIOForRecordReachability(int ioCount) {
            if (ioCount == 0) {
                return;
            }
            if (ioCount <= this.ioCntToCheckIndexReachability.length) {
                int n = ioCount - 1;
                this.ioCntToCheckIndexReachability[n] = this.ioCntToCheckIndexReachability[n] + 1L;
            } else {
                ++this.ioCntMoreThan10ToCheckIndexReachability;
            }
        }

        void onIOTimeToCheckIndexReachability(long nanos) {
            this.ioTimeToCheckIndexReachabilityNanos += nanos;
        }

        private String ioStatsForRecordReachability() {
            StringBuilder sb = new StringBuilder();
            sb.append("ioStatsForRecordReachability[IOLength -> Count]={");
            for (int i = 0; i < this.ioCntToCheckIndexReachability.length; ++i) {
                sb.append(i == 0 ? "" : ", ").append(i + 1).append("->").append(this.ioCntToCheckIndexReachability[i]);
            }
            sb.append(", moreThan10->").append(this.ioCntMoreThan10ToCheckIndexReachability).append("}");
            return sb.toString();
        }

        String readableMetrics() {
            String newLine = System.lineSeparator() + "\t";
            return System.lineSeparator() + "HybridLogCompactorMetrics:" + newLine + "dummyRecords=" + this.dummyRecordsCnt + newLine + "nonDummyRecords=" + this.nonDummyRecordsCnt + newLine + "recordsIteratedOver=" + (this.dummyRecordsCnt + this.nonDummyRecordsCnt) + newLine + "aliveRecords=" + this.aliveRecordsCnt + newLine + "deadRecords=" + this.deadRecordsCnt + newLine + "indexReachabilityIOTime=" + String.format("%.3f", (double)this.ioTimeToCheckIndexReachabilityNanos / 1000000.0) + " millis." + newLine + "compactionTime=" + String.format("%d", this.finishTimeMillis - this.startTimeMillis) + " millis." + newLine + this.ioStatsForRecordReachability();
        }
    }

    private static class InMemorySlotAccessorImpl
    extends TieredStoreSlotAccessor {
        InMemorySlotAccessorImpl(TieredStoreRecordAccessor recordAccessor) {
            super(recordAccessor);
        }

        @Override
        public boolean isAlive(TieredStoreRecord preparedSlot) {
            return true;
        }

        @Override
        public boolean lock(TieredStoreRecord preparedSlot) {
            return true;
        }

        @Override
        public void unlock(TieredStoreRecord preparedSlot) {
        }
    }

    private class AddressRemapperImpl
    implements AddressRemapper<TieredStoreRecord> {
        private AddressRemapperImpl() {
        }

        @Override
        public long remap(TieredStoreRecord record, long oldLogicalAddress, long newLogicalAddressCandidate) {
            long remapResult;
            while (-1L == (remapResult = LogBasedHLogCompactor.this.index.remap(LogBasedHLogCompactor.this.threadIndex, record.getKey(), oldLogicalAddress, newLogicalAddressCandidate))) {
                Thread.yield();
                LogBasedHLogCompactor.this.refreshEpochAndState();
            }
            return remapResult;
        }
    }
}

