/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.FullCompactor;
import com.hazelcast.internal.tstore.compaction.InterruptableCompactor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IndexBasedHLogCompactor
extends InterruptableCompactor<TieredStoreRecord>
implements FullCompactor {
    private final Index index;
    private final State state;
    private final HybridLogImpl log;
    private final Device device;
    private final Epoch epoch;

    public IndexBasedHLogCompactor(Index index, State state, HybridLogImpl log, Device device, Epoch epoch) {
        super(device);
        this.index = index;
        this.state = state;
        this.log = log;
        this.device = device;
        this.epoch = epoch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() {
        int threadIndex = this.epoch.register();
        int epochMask = 15;
        this.state.register(threadIndex);
        try {
            Index.Iterator iterator = this.index.iterator(threadIndex);
            long firstLogicalAddressToRetain = this.log.headAddress();
            int counter = 0;
            while (iterator.hasNext(threadIndex)) {
                this.checkInterrupted();
                iterator.next(threadIndex);
                if ((counter++ & 0xF) != 0) continue;
                this.refreshEpochAndState(threadIndex);
            }
            this.device.truncateAsync(firstLogicalAddressToRetain);
        }
        finally {
            this.state.unregister(threadIndex);
            this.epoch.unregister(threadIndex);
            this.deregister();
        }
    }

    private void refreshEpochAndState(int threadIndex) {
        this.epoch.refresh(threadIndex);
        this.state.refresh(threadIndex);
    }
}

