/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore;

public final class Invariants {
    private Invariants() {
    }

    public static void inRange(int lower, int target, int upper) {
        assert (lower <= target && target <= upper) : "lower=" + lower + ", target=" + target + ", upper=" + upper;
    }

    public static void isTrue(boolean bool, String message) {
        assert (bool) : message;
    }

    public static void isFalse(boolean bool, String message) {
        assert (!bool) : message;
    }

    public static void nonNull(Object o, String message) {
        assert (o != null) : message;
    }

    public static void isNull(Object o, String message) {
        assert (o == null) : message;
    }

    public static void equals(long a, long b) {
        assert (a == b) : Invariants.msg(a, b);
    }

    public static void equals(long a, long b, String message) {
        assert (a == b) : Invariants.msg(a, b) + ", message=" + message;
    }

    public static void equals(int a, int b) {
        assert (a == b) : Invariants.msg(a, b);
    }

    public static void notEquals(long a, long b) {
        assert (a != b) : Invariants.msg(a, b);
    }

    public static void notEquals(int a, int b) {
        assert (a != b) : Invariants.msg(a, b);
    }

    public static void lessThan(long a, long b) {
        assert (a < b) : Invariants.msg(a, b);
    }

    public static void lessThan(int a, int b) {
        assert (a < b) : Invariants.msg(a, b);
    }

    public static void greaterThan(int a, int b) {
        assert (a > b) : Invariants.msg(a, b);
    }

    public static void lessThanOrEqual(long a, long b) {
        assert (a <= b) : Invariants.msg(a, b);
    }

    public static void lessThanOrEqual(int a, int b) {
        assert (a <= b) : Invariants.msg(a, b);
    }

    public static void lessThanOrEqual(int a, int b, String message) {
        assert (a <= b) : Invariants.msg(a, b) + ", message=" + message;
    }

    public static void greaterOrEqualThan(long a, long b) {
        assert (a >= b) : Invariants.msg(a, b);
    }

    public static void greaterOrEqualThan(int a, int b) {
        assert (a >= b) : Invariants.msg(a, b);
    }

    public static void greaterOrEqualThan(int a, int b, String message) {
        assert (a >= b) : Invariants.msg(a, b) + ", message=" + message;
    }

    public static void nonNegative(int a) {
        assert (a >= 0) : "a=" + a;
    }

    public static void nonNegative(int a, String message) {
        assert (a >= 0) : "a=" + a + ", message=" + message;
    }

    public static void nonNegative(long a) {
        assert (a >= 0L) : "a=" + a;
    }

    private static String msg(long a, long b) {
        return "a=" + a + ", b=" + b;
    }

    private static String msg(int a, int b) {
        return "a=" + a + ", b=" + b;
    }
}

