/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.util.QuickMath;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongConsumer;

public final class Epoch {
    private static final boolean DEBUG = Epoch.class.desiredAssertionStatus();
    private static final int CACHE_LINE_SCALE = 6;
    private static final long CACHE_LINE = 64L;
    private static final int ACTION_RECORDS_COUNT = 16;
    private static final long FREE = Long.MAX_VALUE;
    private static final long MAX = 0x7FFFFFFFFFFFFFFEL;
    private static final long PAUSED = 0x7FFFFFFFFFFFFFFEL;
    private static final long LOCKED = 0x7FFFFFFFFFFFFFFEL;
    private static final AtomicLongFieldUpdater<Epoch> CURRENT = AtomicLongFieldUpdater.newUpdater(Epoch.class, "current");
    private static final LongConsumer NOP_EPOCH_CONSUMER = epoch -> {};
    private final int maxThreads;
    private final MemoryAllocator allocator;
    private volatile long current;
    private final long unalignedThreadEpochs;
    private final long threadEpochs;
    private final ActionRecord[] actionRecords = new ActionRecord[16];
    private final ThreadLocal<ThreadIndexRecord> currentThreadIndex = ThreadLocal.withInitial(() -> new ThreadIndexRecord());
    private volatile boolean isClosed;

    public Epoch(int maxThreads, MemoryAllocator allocator) {
        int i;
        this.maxThreads = maxThreads = QuickMath.nextPowerOfTwo(maxThreads);
        this.allocator = allocator;
        this.current = 1L;
        this.unalignedThreadEpochs = allocator.allocate((long)maxThreads + 1L << 6);
        this.threadEpochs = this.unalignedThreadEpochs + 64L - 1L & 0xFFFFFFFFFFFFFFC0L;
        for (i = 0; i < maxThreads; ++i) {
            this.setThreadEpoch(i, Long.MAX_VALUE);
        }
        for (i = 0; i < 16; ++i) {
            this.actionRecords[i] = new ActionRecord();
        }
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public int register() {
        this.checkClosed();
        ThreadIndexRecord threadIndexRecord = this.currentThreadIndex.get();
        int threadIndex = threadIndexRecord.value;
        assert (threadIndex > 0) : "call from action";
        assert (threadIndex == 0x7FFFFFFE) : Thread.currentThread().getName() + " is already registered";
        int mask = this.maxThreads - 1;
        threadIndex = (int)Thread.currentThread().getId() & mask;
        block0: while (true) {
            for (int i = 0; i < this.maxThreads; ++i) {
                long threadEpoch = this.getThreadEpoch(threadIndex);
                if (threadEpoch == Long.MAX_VALUE && this.casThreadEpoch(threadIndex, Long.MAX_VALUE, this.current)) break block0;
                threadIndex = threadIndex + 1 & mask;
            }
            Thread.yield();
        }
        threadIndexRecord.value = threadIndex;
        return threadIndex;
    }

    public boolean isCurrentThreadRegistered() {
        this.checkClosed();
        int threadIndex = this.currentThreadIndex.get().value;
        return threadIndex != 0x7FFFFFFE;
    }

    public int getCurrentThreadIndex() {
        this.checkClosed();
        int threadIndex = this.currentThreadIndex.get().value;
        if (DEBUG && threadIndex < 0) {
            threadIndex = -threadIndex - 1;
        }
        assert (threadIndex != 0x7FFFFFFE) : "not registered";
        return threadIndex;
    }

    public void refresh(int threadIndex) {
        assert (threadIndex >= 0) : "threadIndex=" + threadIndex;
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered";
        assert (threadEpoch != 0x7FFFFFFFFFFFFFFEL) : "paused";
        long current = this.current;
        this.setThreadEpoch(threadIndex, current);
        long safe = this.computeSafeEpoch(current);
        this.runSafeActions(threadIndex, safe, current);
    }

    public void bump(int threadIndex, Action action) {
        this.bump(threadIndex, action, NOP_EPOCH_CONSUMER);
    }

    public void bump(int threadIndex, Action action, LongConsumer epochConsumer) {
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered";
        assert (threadEpoch != 0x7FFFFFFFFFFFFFFEL) : "paused";
        long current = CURRENT.incrementAndGet(this);
        epochConsumer.accept(current);
        while (true) {
            long previous = current - 1L;
            this.setThreadEpoch(threadIndex, current);
            long safe = this.computeSafeEpoch(current);
            this.runSafeActions(threadIndex, safe, current);
            if (previous <= safe) {
                this.run(action, threadIndex, previous, current);
                return;
            }
            for (int i = 0; i < 16; ++i) {
                ActionRecord actionRecord = this.actionRecords[i];
                if (actionRecord.epoch != Long.MAX_VALUE || !ActionRecord.EPOCH.compareAndSet(actionRecord, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL)) continue;
                actionRecord.action = action;
                ActionRecord.EPOCH.set(actionRecord, previous);
                return;
            }
            Thread.yield();
            current = this.current;
        }
    }

    public void unregister(int threadIndex) {
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered";
        assert (threadEpoch != 0x7FFFFFFFFFFFFFFEL) : "paused";
        this.setThreadEpoch(threadIndex, 0x7FFFFFFFFFFFFFFEL);
        long current = CURRENT.incrementAndGet(this);
        long safe = this.computeSafeEpoch(current);
        this.runSafeActions(threadIndex, safe, 0x7FFFFFFFFFFFFFFEL);
        this.currentThreadIndex.get().value = 0x7FFFFFFE;
        this.setThreadEpoch(threadIndex, Long.MAX_VALUE);
    }

    public void pause(int threadIndex) {
        assert (threadIndex >= 0) : "threadIndex=" + threadIndex;
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered";
        assert (threadEpoch != 0x7FFFFFFFFFFFFFFEL) : "already paused";
        this.setThreadEpoch(threadIndex, 0x7FFFFFFFFFFFFFFEL);
        long current = CURRENT.incrementAndGet(this);
        long safe = this.computeSafeEpoch(current);
        this.runSafeActions(threadIndex, safe, 0x7FFFFFFFFFFFFFFEL);
    }

    public void resume(int threadIndex) {
        assert (threadIndex >= 0) : "threadIndex=" + threadIndex;
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered";
        assert (threadEpoch == 0x7FFFFFFFFFFFFFFEL) : "not paused";
        this.setThreadEpoch(threadIndex, this.current);
    }

    public void close() {
        this.checkClosed();
        this.isClosed = true;
        this.allocator.free(this.unalignedThreadEpochs, (long)this.maxThreads + 1L << 6);
    }

    public String debugInfo() {
        this.checkClosed();
        int threadIdx = this.currentThreadIndex.get().value;
        long threadEpoch = this.getThreadEpoch(threadIdx);
        StringBuilder sb = new StringBuilder();
        String ln = System.lineSeparator();
        String tab = "\t";
        long current = CURRENT.get(this);
        sb.append(Thread.currentThread().getName()).append(" -- Epoch#debugInfo:").append(ln).append("currentThreadIndex=").append(threadIdx).append(", currentThreadEpoch=").append(threadEpoch).append(ln).append("globalEpoch=").append(current).append(ln).append("safeEpoch=").append(this.computeSafeEpoch(current)).append(ln);
        sb.append("ActionRecords:").append(ln);
        for (ActionRecord r : this.actionRecords) {
            sb.append(tab).append("epoch=");
            if (r.epoch == Long.MAX_VALUE) {
                sb.append("FREE");
            } else if (r.epoch == 0x7FFFFFFFFFFFFFFEL) {
                sb.append("LOCKED");
            } else {
                sb.append(r.epoch);
            }
            sb.append(ln);
        }
        sb.append(ln);
        return sb.toString();
    }

    public long nativeMemoryConsumptionBytes() {
        return (long)this.maxThreads + 1L << 6;
    }

    public boolean inEpochAction() {
        if (!DEBUG) {
            throw new IllegalStateException("Epoch.inEpochAction() should be called only when assertions are enabled (from assertions)");
        }
        return this.currentThreadIndex.get().value < 0;
    }

    void register(int threadIndex) {
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch == Long.MAX_VALUE) : "already registered";
        this.setThreadEpoch(threadIndex, this.current);
    }

    private long computeSafeEpoch(long current) {
        long oldest = current;
        for (int i = 0; i < this.maxThreads; ++i) {
            long threadEpoch = this.getThreadEpoch(i);
            if (DEBUG) {
                threadEpoch = Math.abs(threadEpoch);
            }
            oldest = Math.min(oldest, threadEpoch);
        }
        return oldest - 1L;
    }

    private void runSafeActions(int threadIndex, long safe, long threadEpoch) {
        for (int i = 0; i < 16; ++i) {
            ActionRecord actionRecord = this.actionRecords[i];
            long epoch = actionRecord.epoch;
            if (epoch > safe || !ActionRecord.EPOCH.compareAndSet(actionRecord, epoch, 0x7FFFFFFFFFFFFFFEL)) continue;
            Action action = actionRecord.action;
            actionRecord.action = null;
            ActionRecord.EPOCH.set(actionRecord, Long.MAX_VALUE);
            this.run(action, threadIndex, epoch, threadEpoch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Action action, int threadIndex, long actionEpoch, long threadEpoch) {
        if (DEBUG) {
            this.currentThreadIndex.get().value = -(threadIndex + 1);
            this.setThreadEpoch(threadIndex, -threadEpoch);
        }
        try {
            action.run(threadIndex, actionEpoch);
        }
        finally {
            if (DEBUG) {
                this.setThreadEpoch(threadIndex, threadEpoch);
                this.currentThreadIndex.get().value = threadIndex;
            }
        }
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Epoch has been closed/disposed.");
        }
    }

    public long getThreadEpoch(int threadIndex) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(this.threadEpochs + ((long)threadIndex << 6));
    }

    private void setThreadEpoch(int threadIndex, long epoch) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(this.threadEpochs + ((long)threadIndex << 6), epoch);
    }

    private boolean casThreadEpoch(int threadIndex, long expected, long epoch) {
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(this.threadEpochs + ((long)threadIndex << 6), expected, epoch);
    }

    private static final class ThreadIndexRecord {
        static final int FREE = 0x7FFFFFFE;
        int value = 0x7FFFFFFE;

        private ThreadIndexRecord() {
        }
    }

    private static final class ActionRecord {
        static final AtomicLongFieldUpdater<ActionRecord> EPOCH = AtomicLongFieldUpdater.newUpdater(ActionRecord.class, "epoch");
        volatile long epoch = Long.MAX_VALUE;
        Action action;

        private ActionRecord() {
        }
    }

    @FunctionalInterface
    public static interface Action {
        public void run(int var1, long var2);
    }
}

