/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.HeapMemoryAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.EnterpriseBufferObjectDataOutput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.EnterpriseClusterVersionAware;
import com.hazelcast.internal.serialization.impl.EnterpriseDataSerializableHeader;
import com.hazelcast.internal.serialization.impl.EnterpriseDataSerializableSerializer;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.SerializationServiceV1;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.SerializerAdapter;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPool;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.partition.PartitioningStrategy;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Map;

public final class EnterpriseSerializationServiceV1
extends SerializationServiceV1
implements EnterpriseSerializationService {
    private static final int FACTORY_AND_CLASS_ID_BYTE_LENGTH = 8;
    private static final int VERSION_BYTE_LENGTH = 2;
    private final HazelcastMemoryManager memoryManager;
    private final ThreadLocal<MemoryAllocator> mallocThreadLocal = new ThreadLocal();

    EnterpriseSerializationServiceV1(Builder builder) {
        super(builder);
        this.memoryManager = builder.memoryManager;
        this.overrideConstantSerializers(builder.getClassLoader(), builder.clusterVersionAware, builder.getDataSerializableFactories(), builder.versionedSerializationEnabled, builder.isCompatibility());
    }

    private void overrideConstantSerializers(ClassLoader classLoader, EnterpriseClusterVersionAware clusterVersionAware, Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories, boolean versionedSerializationEnabled, boolean compatibility) {
        if (versionedSerializationEnabled) {
            clusterVersionAware = Preconditions.checkNotNull(clusterVersionAware, "ClusterVersionAware can't be null");
            this.dataSerializerAdapter = SerializationUtil.createSerializerAdapter(new EnterpriseDataSerializableSerializer(dataSerializableFactories, classLoader, clusterVersionAware, compatibility));
            this.registerConstant(DataSerializable.class, this.dataSerializerAdapter);
        }
    }

    @Override
    public MemoryAllocator getCurrentMemoryAllocator() {
        MemoryAllocator malloc = this.mallocThreadLocal.get();
        return malloc != null ? malloc : this.memoryManager;
    }

    @Override
    public <B extends Data> B toData(Object obj, DataType type) {
        return this.toDataInternal(obj, type, this.globalPartitioningStrategy, this.getCurrentMemoryAllocator());
    }

    @Override
    public <B extends Data> B toNativeData(Object obj, MemoryAllocator malloc) {
        return this.toDataInternal(obj, DataType.NATIVE, this.globalPartitioningStrategy, malloc);
    }

    @Override
    public <B extends Data> B toData(Object obj, DataType type, PartitioningStrategy strategy) {
        return this.toDataInternal(obj, type, strategy, this.getCurrentMemoryAllocator());
    }

    private <B extends Data> B toDataInternal(Object obj, DataType type, PartitioningStrategy strategy, MemoryAllocator malloc) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return this.convertData((Data)obj, type);
        }
        if (type == DataType.HEAP) {
            return super.toData(obj, strategy);
        }
        if (type == DataType.NATIVE) {
            return this.toNativeDataInternal(obj, true, strategy, malloc);
        }
        throw new IllegalArgumentException("Unknown data type: " + (Object)((Object)type));
    }

    private <B extends Data> B toNativeDataInternal(Object obj, boolean writeHash, PartitioningStrategy strategy, MemoryAllocator malloc) {
        if (obj == null) {
            return null;
        }
        if (malloc == null) {
            throw new IllegalArgumentException("MemoryManager is required!");
        }
        BufferPool pool = this.bufferPoolThreadLocal.get();
        EnterpriseBufferObjectDataOutput out = (EnterpriseBufferObjectDataOutput)pool.takeOutputBuffer();
        try {
            SerializerAdapter serializer = this.serializerFor(obj, false);
            if (writeHash) {
                int partitionHash = this.calculatePartitionHash(obj, strategy);
                out.writeInt(partitionHash, ByteOrder.BIG_ENDIAN);
            }
            out.writeInt(serializer.getTypeId(), ByteOrder.BIG_ENDIAN);
            serializer.write(out, obj);
            int size = out.position();
            int memSize = size + 4;
            long address = malloc.allocate(memSize);
            assert (address != 0L) : "Illegal memory access: " + address;
            NativeMemoryData data = new NativeMemoryData(address, memSize);
            data.writeInt(0L, size);
            out.copyToMemoryBlock(data, 4, size);
            NativeMemoryData nativeMemoryData = data;
            return (B)nativeMemoryData;
        }
        catch (Throwable e) {
            throw SerializationUtil.handleException(e);
        }
        finally {
            pool.returnOutputBuffer(out);
        }
    }

    @Override
    public <B extends Data> B convertData(Data data, DataType type) {
        return EnterpriseSerializationServiceV1.convertDataInternal(data, type, this.getCurrentMemoryAllocator());
    }

    @Override
    public <B extends Data> B convertToNativeData(Data data, MemoryAllocator malloc) {
        return EnterpriseSerializationServiceV1.convertDataInternal(data, DataType.NATIVE, malloc);
    }

    private static <B extends Data> B convertDataInternal(Data data, DataType type, MemoryAllocator malloc) {
        if (data == null) {
            return null;
        }
        switch (type) {
            case NATIVE: {
                if (!(data instanceof HeapData)) break;
                if (malloc == null) {
                    throw new HazelcastSerializationException("MemoryManager is required!");
                }
                int size = data.totalSize();
                int memSize = size + 4;
                long address = malloc.allocate(memSize);
                NativeMemoryData nativeData = new NativeMemoryData(address, memSize);
                nativeData.writeInt(0L, size);
                nativeData.copyFrom(4L, data.toByteArray(), HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET, size);
                return (B)nativeData;
            }
            case HEAP: {
                if (!(data instanceof NativeMemoryData)) break;
                return (B)new HeapData(data.toByteArray());
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return (B)data;
    }

    @Override
    public void disposeData(Data data) {
        this.disposeDataInternal(data, this.getCurrentMemoryAllocator());
    }

    @Override
    public void disposeData(Data data, MemoryAllocator memoryAllocator) {
        this.disposeDataInternal(data, memoryAllocator);
    }

    private void disposeDataInternal(Data data, MemoryAllocator malloc) {
        if (data instanceof NativeMemoryData) {
            if (malloc == null) {
                throw new HazelcastSerializationException("MemoryManager is required!");
            }
            NativeMemoryData memoryBlock = (NativeMemoryData)data;
            if (memoryBlock.address() != 0L) {
                malloc.free(memoryBlock.address(), memoryBlock.size());
                memoryBlock.reset(0L);
            }
        } else {
            super.disposeData(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T toObject(Object data, MemoryAllocator memoryAllocator) {
        try {
            this.mallocThreadLocal.set(memoryAllocator);
            Object t = super.toObject(data);
            return t;
        }
        finally {
            this.mallocThreadLocal.remove();
        }
    }

    @Override
    public HazelcastMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.memoryManager != null) {
            this.memoryManager.dispose();
        }
    }

    @Override
    public ObjectDataInput initDataSerializableInputAndSkipTheHeader(Data data) throws IOException {
        BufferObjectDataInput input = this.createObjectDataInput(data);
        byte header = input.readByte();
        if (EnterpriseDataSerializableHeader.isIdentifiedDataSerializable(header)) {
            this.skipBytesSafely(input, 8);
        } else {
            input.readString();
        }
        if (EnterpriseDataSerializableHeader.isVersioned(header)) {
            this.skipBytesSafely(input, 2);
        }
        return input;
    }

    private void skipBytesSafely(ObjectDataInput input, int count) throws IOException {
        if (input.skipBytes(count) != count) {
            throw new HazelcastSerializationException("Malformed serialization format");
        }
    }

    public static Builder enterpriseBuilder() {
        return new Builder();
    }

    public static final class Builder
    extends SerializationServiceV1.AbstractBuilder<Builder> {
        private HazelcastMemoryManager memoryManager;
        private EnterpriseClusterVersionAware clusterVersionAware;
        private boolean versionedSerializationEnabled;

        private Builder() {
        }

        public Builder withMemoryManager(HazelcastMemoryManager memoryManager) {
            this.memoryManager = memoryManager;
            return this.self();
        }

        public Builder withClusterVersionAware(EnterpriseClusterVersionAware clusterVersionAware) {
            this.clusterVersionAware = clusterVersionAware;
            return this.self();
        }

        public Builder withVersionedSerializationEnabled(boolean versionedSerializationEnabled) {
            this.versionedSerializationEnabled = versionedSerializationEnabled;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }

        public EnterpriseSerializationServiceV1 build() {
            return new EnterpriseSerializationServiceV1(this);
        }
    }
}

