/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.tcp;

import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.internal.networking.ChannelOption;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.nio.CipherHelper;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.nio.PacketIOHelper;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.PacketDecoder;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.logging.ILogger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

public class SymmetricCipherPacketDecoder
extends PacketDecoder {
    private final ILogger logger;
    private final Cipher cipher;
    private final PacketIOHelper packetReader = new PacketIOHelper();
    private ByteBuffer cipherBuffer;
    private int size = -1;

    public SymmetricCipherPacketDecoder(SymmetricEncryptionConfig sic, ServerConnection connection, ServerContext serverContext, Consumer<Packet> dst) {
        super(connection, dst);
        this.logger = serverContext.getLoggingService().getLogger(this.getClass());
        this.cipher = CipherHelper.createSymmetricReaderCipher(sic, connection);
    }

    @Override
    public void handlerAdded() {
        super.handlerAdded();
        this.cipherBuffer = ByteBuffer.allocate(this.channel.options().getOption(ChannelOption.SO_RCVBUF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public HandlerStatus onRead() throws Exception {
        JVMUtil.upcast((Buffer)this.src).flip();
        try {
            while (((ByteBuffer)this.src).hasRemaining()) {
                block15: {
                    if (this.size != -1) ** GOTO lbl15
                    if (((ByteBuffer)this.src).remaining() >= 4) break block15;
                    var1_1 = HandlerStatus.CLEAN;
                    return var1_1;
                }
                try {
                    this.size = ((ByteBuffer)this.src).getInt();
                    if (this.cipherBuffer.capacity() < this.size) {
                        this.cipherBuffer = ByteBuffer.allocate(this.size);
                    }
lbl15:
                    // 4 sources

                    if ((remaining = ((ByteBuffer)this.src).remaining()) < this.size) {
                        this.cipher.update((ByteBuffer)this.src, this.cipherBuffer);
                        this.size -= remaining;
                    } else if (remaining == this.size) {
                        this.cipher.doFinal((ByteBuffer)this.src, this.cipherBuffer);
                        this.size = -1;
                    } else {
                        oldLimit = ((ByteBuffer)this.src).limit();
                        newLimit = ((ByteBuffer)this.src).position() + this.size;
                        JVMUtil.upcast((Buffer)this.src).limit(newLimit);
                        this.cipher.doFinal((ByteBuffer)this.src, this.cipherBuffer);
                        JVMUtil.upcast((Buffer)this.src).limit(oldLimit);
                        this.size = -1;
                    }
                }
                catch (ShortBufferException e) {
                    this.logger.warning(e);
                }
                JVMUtil.upcast(this.cipherBuffer).flip();
                while (this.cipherBuffer.hasRemaining() && (packet = this.packetReader.readFrom(this.cipherBuffer)) != null) {
                    this.onPacketComplete(packet);
                }
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                    continue;
                }
                JVMUtil.upcast(this.cipherBuffer).clear();
            }
            var1_5 = HandlerStatus.CLEAN;
            return var1_5;
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)this.src);
        }
    }
}

