/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.internal.nio.IOUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLEngineFactorySupport {
    public static final String JAVA_NET_SSL_PREFIX = "javax.net.ssl.";
    protected KeyManagerFactory kmf;
    protected TrustManagerFactory tmf;
    protected String protocol;

    protected void load(Properties properties) throws Exception {
        String keyStorePassword = SSLEngineFactorySupport.getProperty(properties, "keyStorePassword");
        String keyStore = SSLEngineFactorySupport.getProperty(properties, "keyStore");
        String keyManagerAlgorithm = SSLEngineFactorySupport.getProperty(properties, "keyManagerAlgorithm", KeyManagerFactory.getDefaultAlgorithm());
        String keyStoreType = SSLEngineFactorySupport.getProperty(properties, "keyStoreType", "JKS");
        String trustStore = SSLEngineFactorySupport.getProperty(properties, "trustStore");
        String trustStorePassword = SSLEngineFactorySupport.getProperty(properties, "trustStorePassword");
        String trustManagerAlgorithm = SSLEngineFactorySupport.getProperty(properties, "trustManagerAlgorithm", TrustManagerFactory.getDefaultAlgorithm());
        String trustStoreType = SSLEngineFactorySupport.getProperty(properties, "trustStoreType", "JKS");
        this.protocol = SSLEngineFactorySupport.getProperty(properties, "protocol", "TLS");
        this.kmf = SSLEngineFactorySupport.loadKeyManagerFactory(keyStorePassword, keyStore, keyManagerAlgorithm, keyStoreType);
        this.tmf = SSLEngineFactorySupport.loadTrustManagerFactory(trustStorePassword, trustStore, trustManagerAlgorithm, trustStoreType);
    }

    public static TrustManagerFactory loadTrustManagerFactory(String trustStorePassword, String trustStore, String trustManagerAlgorithm) throws Exception {
        return SSLEngineFactorySupport.loadTrustManagerFactory(trustStorePassword, trustStore, trustManagerAlgorithm, "JKS");
    }

    public static TrustManagerFactory loadTrustManagerFactory(String trustStorePassword, String trustStore, String trustManagerAlgorithm, String trustStoreType) throws Exception {
        if (trustStore == null) {
            return null;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        KeyStore ts = KeyStore.getInstance(trustStoreType);
        char[] passPhrase = trustStorePassword == null ? null : trustStorePassword.toCharArray();
        SSLEngineFactorySupport.loadKeyStore(ts, passPhrase, trustStore);
        tmf.init(ts);
        return tmf;
    }

    public static KeyManagerFactory loadKeyManagerFactory(String keyStorePassword, String keyStore, String keyManagerAlgorithm) throws Exception {
        return SSLEngineFactorySupport.loadKeyManagerFactory(keyStorePassword, keyStore, keyManagerAlgorithm, "JKS");
    }

    public static KeyManagerFactory loadKeyManagerFactory(String keyStorePassword, String keyStore, String keyManagerAlgorithm, String keyStoreType) throws Exception {
        if (keyStore == null) {
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        char[] passPhrase = keyStorePassword == null ? null : keyStorePassword.toCharArray();
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        SSLEngineFactorySupport.loadKeyStore(ks, passPhrase, keyStore);
        kmf.init(ks, passPhrase);
        return kmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadKeyStore(KeyStore ks, char[] passPhrase, String keyStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException {
        FileInputStream in = new FileInputStream(keyStoreFile);
        try {
            ks.load(in, passPhrase);
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    public static String getProperty(Properties properties, String property) {
        String value = properties.getProperty(property);
        if (value == null) {
            value = properties.getProperty(JAVA_NET_SSL_PREFIX + property);
        }
        if (value == null) {
            value = System.getProperty(JAVA_NET_SSL_PREFIX + property);
        }
        return value;
    }

    public static String getProperty(Properties properties, String property, String defaultValue) {
        String value = SSLEngineFactorySupport.getProperty(properties, property);
        return value != null ? value : defaultValue;
    }
}

