/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio;

import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.BasicSymmetricCipherBuilder;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class CipherHelper {
    private static final ILogger LOGGER = Logger.getLogger(CipherHelper.class);

    private CipherHelper() {
    }

    public static Cipher createSymmetricReaderCipher(SymmetricEncryptionConfig config) {
        return CipherHelper.createSymmetricReaderCipher(config, null);
    }

    public static Cipher createSymmetricReaderCipher(SymmetricEncryptionConfig config, Connection connection) {
        return CipherHelper.createCipher(config, connection, false, "Symmetric Cipher for ReadHandler cannot be initialized");
    }

    public static Cipher createSymmetricWriterCipher(SymmetricEncryptionConfig config) {
        return CipherHelper.createSymmetricWriterCipher(config, null);
    }

    public static Cipher createSymmetricWriterCipher(SymmetricEncryptionConfig config, Connection connection) {
        return CipherHelper.createCipher(config, connection, true, "Symmetric Cipher for WriteHandler cannot be initialized");
    }

    private static synchronized Cipher createCipher(SymmetricEncryptionConfig config, Connection connection, boolean createWriter, String exceptionMessage) {
        try {
            SymmetricCipherBuilder symmetricCipherBuilder = new SymmetricCipherBuilder(config);
            return symmetricCipherBuilder.create(createWriter, config.getKey());
        }
        catch (Exception e) {
            LOGGER.severe(exceptionMessage, e);
            if (connection != null) {
                connection.close(null, e);
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    static void initBouncySecurityProvider() {
        try {
            if (Boolean.getBoolean("hazelcast.security.bouncy.enabled")) {
                String provider = "org.bouncycastle.jce.provider.BouncyCastleProvider";
                Security.addProvider((Provider)Class.forName(provider).newInstance());
            }
        }
        catch (Exception e) {
            LOGGER.warning(e);
        }
    }

    static {
        CipherHelper.initBouncySecurityProvider();
    }

    static class SymmetricCipherBuilder
    extends BasicSymmetricCipherBuilder {
        private final String passPhrase;
        private final int iterationCount;

        SymmetricCipherBuilder(SymmetricEncryptionConfig config) {
            super(config);
            this.passPhrase = String.valueOf(config.getPassword());
            this.iterationCount = config.getIterationCount();
        }

        @Override
        public Cipher create(boolean encryptMode, byte[] keyBytes) {
            if (keyBytes == null) {
                try {
                    int maxAllowedKeyBitsLen = Cipher.getMaxAllowedKeyLength(this.algorithm);
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    byte[] passPhraseBytes = StringUtil.stringToBytes(this.passPhrase);
                    ByteBuffer combined = ByteBuffer.wrap(new byte[passPhraseBytes.length + this.salt.length]);
                    combined.put(passPhraseBytes);
                    combined.put(this.salt);
                    int maxAllowedKeyBytesLen = Math.min(maxAllowedKeyBitsLen / 8, 32);
                    keyBytes = new byte[maxAllowedKeyBytesLen];
                    System.arraycopy(md.digest(combined.array()), 0, keyBytes, 0, maxAllowedKeyBytesLen);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.create(encryptMode, keyBytes);
        }

        @Override
        protected BasicSymmetricCipherBuilder.CipherParams createCipherParams(byte[] keyBytes) throws GeneralSecurityException {
            if (this.algorithm.startsWith("PBEWith")) {
                PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.iterationCount);
                PBEKeySpec keySpec = new PBEKeySpec(this.passPhrase.toCharArray(), this.salt, this.iterationCount);
                String keyAlgorithm = SymmetricCipherBuilder.findKeyAlgorithm(this.algorithm);
                SecretKey key = SecretKeyFactory.getInstance(keyAlgorithm).generateSecret(keySpec);
                return new BasicSymmetricCipherBuilder.CipherParams(8, key, paramSpec);
            }
            return super.createCipherParams(keyBytes);
        }
    }
}

