/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.nativememory;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.nearcache.impl.nativememory.HDNearCacheRecordStoreImpl;
import com.hazelcast.internal.nearcache.impl.nativememory.LockableNearCacheRecordStoreSegment;
import com.hazelcast.internal.serialization.Data;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class LockableNearCacheRecordStoreSegmentIterator
implements Iterator<Data>,
Closeable {
    private final Thread ownerThread = Thread.currentThread();
    private final HDNearCacheRecordStoreImpl[] segments;
    private final boolean[] obtainedLocks;
    private int segmentIndex = -1;
    private LockableNearCacheRecordStoreSegment segment;
    private Iterator<Data> segmentKeySetIterator;

    LockableNearCacheRecordStoreSegmentIterator(HDNearCacheRecordStoreImpl[] segments) {
        this.segments = segments;
        this.obtainedLocks = new boolean[segments.length];
    }

    @Override
    public boolean hasNext() {
        if (this.segmentKeySetIterator == null) {
            this.lockNextSegment();
        }
        if (this.segmentKeySetIterator.hasNext()) {
            return true;
        }
        this.unlockCurrentSegment();
        if (!this.lockNextSegment()) {
            return false;
        }
        return this.hasNext();
    }

    @Override
    public Data next() {
        if (this.segmentKeySetIterator == null) {
            this.lockNextSegment();
        }
        while (!this.segmentKeySetIterator.hasNext()) {
            this.unlockCurrentSegment();
            if (this.lockNextSegment()) continue;
            throw new NoSuchElementException();
        }
        return this.segmentKeySetIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        int foundLocks = 0;
        for (int i = 0; i < this.obtainedLocks.length; ++i) {
            if (!this.obtainedLocks[i]) continue;
            ((LockableNearCacheRecordStoreSegment)((Object)this.segments[i])).unlock();
            ++foundLocks;
        }
        if (foundLocks > 0) {
            throw new IOException("Found " + foundLocks + " locked segments in LockableNearCacheRecordStoreSegmentIterator!");
        }
    }

    private boolean lockNextSegment() {
        if (Thread.currentThread() != this.ownerThread) {
            throw new HazelcastException("LockableNearCacheRecordStoreSegmentIterator is not thread-safe! Don't hand it over to another thread during usage.");
        }
        if (++this.segmentIndex >= this.segments.length) {
            return false;
        }
        this.segment = (LockableNearCacheRecordStoreSegment)((Object)this.segments[this.segmentIndex]);
        this.obtainedLocks[this.segmentIndex] = true;
        this.segment.lock();
        this.segmentKeySetIterator = this.segment.getKeySetIterator();
        return true;
    }

    private void unlockCurrentSegment() {
        if (Thread.currentThread() != this.ownerThread) {
            throw new HazelcastException("LockableNearCacheRecordStoreSegmentIterator is not thread-safe! Don't hand it over to another thread during usage.");
        }
        if (this.segmentIndex >= this.segments.length) {
            return;
        }
        this.segment.unlock();
        this.obtainedLocks[this.segmentIndex] = false;
    }
}

