/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.io;

import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileOut;
import com.hazelcast.internal.util.JVMUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class EncryptedChunkFileOut
extends ChunkFileOut {
    private static final int CIPHER_OVERHEAD = 128;
    private byte[] outBuffer = new byte[65664];
    private ByteBuffer outByteBuffer = ByteBuffer.wrap(this.outBuffer);
    private final Cipher cipher;
    private boolean closed;

    public EncryptedChunkFileOut(File file, MutatorCatchup mc, Cipher cipher) throws IOException {
        super(file, mc);
        this.cipher = cipher;
    }

    @Override
    protected int doWrite(FileChannel chan, ByteBuffer from) throws IOException {
        assert (this.cipher.getOutputSize(from.remaining()) <= this.outBuffer.length);
        try {
            JVMUtil.upcast(this.outByteBuffer).clear();
            this.cipher.update(from, this.outByteBuffer);
            assert (from.remaining() == 0);
            JVMUtil.upcast(this.outByteBuffer).flip();
            return chan.write(this.outByteBuffer);
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected int doWrite(FileOutputStream fos, byte[] b, int off, int len) throws IOException {
        assert (this.cipher.getOutputSize(len) <= this.outBuffer.length);
        try {
            int written = this.cipher.update(b, off, len, this.outBuffer);
            if (written > 0) {
                fos.write(this.outBuffer, 0, written);
            }
            return written;
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void prepareClose(FileOutputStream fos) throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                int written = this.cipher.doFinal(this.outBuffer, 0);
                if (written > 0) {
                    fos.write(this.outBuffer, 0, written);
                }
            }
            catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
                throw new IOException(e);
            }
            super.prepareClose(fos);
        }
    }
}

