/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.cluster.ClusterMetadataManager;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterSerializerHook;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SendExpectedMembersOperation
extends Operation
implements JoinOperation {
    private Map<UUID, Address> expectedMembers;

    public SendExpectedMembersOperation() {
    }

    public SendExpectedMembersOperation(Map<UUID, Address> expectedMembers) {
        this.expectedMembers = expectedMembers;
    }

    @Override
    public void run() throws Exception {
        HotRestartIntegrationService service = (HotRestartIntegrationService)this.getService();
        ClusterMetadataManager clusterMetadataManager = service.getClusterMetadataManager();
        clusterMetadataManager.receiveExpectedMembersFromMaster(this.getCallerAddress(), this.expectedMembers);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:ee:internalHotRestartService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.expectedMembers.size());
        for (Map.Entry<UUID, Address> entry : this.expectedMembers.entrySet()) {
            UUIDSerializationUtil.writeUUID(out, entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.expectedMembers = new HashMap<UUID, Address>(size);
        for (int i = 0; i < size; ++i) {
            UUID uuid = UUIDSerializationUtil.readUUID(in);
            Address address = (Address)in.readObject();
            this.expectedMembers.put(uuid, address);
        }
    }

    @Override
    public int getFactoryId() {
        return HotRestartClusterSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }
}

