/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart;

import com.hazelcast.config.EncryptionAtRestConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.hotrestart.impl.encryption.HotRestartCipherBuilder;
import com.hazelcast.internal.hotrestart.impl.encryption.InitialKeysSupplier;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.spi.impl.securestore.SecureStore;
import com.hazelcast.spi.impl.securestore.impl.DefaultSecureStoreFactory;
import java.util.List;

final class EncryptionHelper
implements Disposable,
InitialKeysSupplier {
    private final EncryptionAtRestConfig encryptionAtRestConfig;
    private final int keySize;
    private SecureStore secureStore;

    EncryptionHelper(EncryptionAtRestConfig encryptionAtRestConfig) {
        this.encryptionAtRestConfig = encryptionAtRestConfig;
        this.keySize = encryptionAtRestConfig.getKeySize();
    }

    HotRestartCipherBuilder newCipherBuilder() {
        return this.encryptionAtRestConfig.isEnabled() ? new HotRestartCipherBuilder(this.encryptionAtRestConfig) : null;
    }

    int getKeySize() {
        return this.keySize;
    }

    void prepare(Node node, SecureStore.EncryptionKeyListener encryptionKeyListener) {
        SecureStore secureStore = this.secureStore = this.encryptionAtRestConfig.isEnabled() ? new DefaultSecureStoreFactory(node).getSecureStore(this.encryptionAtRestConfig.getSecureStoreConfig()) : null;
        if (this.secureStore != null && encryptionKeyListener != null) {
            this.secureStore.addEncryptionKeyListener(encryptionKeyListener);
        }
    }

    @Override
    public void dispose() {
        if (this.secureStore instanceof Disposable) {
            ((Disposable)((Object)this.secureStore)).dispose();
        }
        this.secureStore = null;
    }

    @Override
    public List<byte[]> get() {
        if (this.secureStore != null) {
            return this.secureStore.retrieveEncryptionKeys();
        }
        return null;
    }
}

