/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hidensity.impl;

import com.hazelcast.internal.hidensity.HiDensityRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordAccessor;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import java.util.ArrayDeque;
import java.util.Queue;

public class DefaultHiDensityRecordProcessor<R extends HiDensityRecord>
implements HiDensityRecordProcessor<R> {
    protected final EnterpriseSerializationService serializationService;
    protected final HiDensityRecordAccessor<R> recordAccessor;
    protected final HazelcastMemoryManager memoryManager;
    protected final HiDensityStorageInfo storageInfo;
    protected final Queue<MemoryBlock> deferredBlocksQueue = new ArrayDeque<MemoryBlock>(8);

    public DefaultHiDensityRecordProcessor(EnterpriseSerializationService serializationService, HiDensityRecordAccessor<R> recordAccessor, HazelcastMemoryManager memoryManager, HiDensityStorageInfo storageInfo) {
        this.serializationService = serializationService;
        this.recordAccessor = recordAccessor;
        this.memoryManager = memoryManager;
        this.storageInfo = storageInfo;
    }

    @Override
    public boolean isEqual(long address, R value) {
        return this.recordAccessor.isEqual(address, value);
    }

    @Override
    public boolean isEqual(long address1, long address2) {
        return this.recordAccessor.isEqual(address1, address2);
    }

    @Override
    public R read(long address) {
        return (R)((HiDensityRecord)this.recordAccessor.read(address));
    }

    @Override
    public long dispose(long address) {
        long size = this.recordAccessor.dispose(address);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    @Override
    public long dispose(R block) {
        long size = this.recordAccessor.dispose(block);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    @Override
    public R newRecord() {
        return this.recordAccessor.newRecord();
    }

    @Override
    public NativeMemoryData readData(long valueAddress) {
        return this.recordAccessor.readData(valueAddress);
    }

    @Override
    public Object readValue(R record) {
        return this.recordAccessor.readValue(record);
    }

    @Override
    public long readValueAddress(R record) {
        return this.recordAccessor.readValueAddress(record);
    }

    @Override
    public void setValueAddress(R record, long address) {
        this.recordAccessor.setValueAddress(record, address);
    }

    @Override
    public void setValue(R record, Data value) {
        this.recordAccessor.setValue(record, value);
    }

    @Override
    public long disposeValue(R record) {
        long size = this.recordAccessor.disposeValue(record);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    @Override
    public long disposeData(NativeMemoryData data) {
        long size = this.recordAccessor.disposeData(data);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    @Override
    public long disposeData(long address) {
        long size = this.recordAccessor.disposeData(address);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    @Override
    public Data toData(Object obj, DataType dataType) {
        Object data = dataType == DataType.NATIVE ? this.serializationService.toNativeData(obj, this.memoryManager) : this.serializationService.toData(obj, dataType);
        if (data instanceof NativeMemoryData && data != obj) {
            this.storageInfo.addUsedMemory(this.recordAccessor.getSize((NativeMemoryData)data));
        }
        return data;
    }

    @Override
    public Object toObject(Object data) {
        return this.serializationService.toObject(data, this.memoryManager);
    }

    @Override
    public Data convertData(Data data, DataType dataType) {
        Object convertedData = dataType == DataType.NATIVE ? this.serializationService.convertToNativeData(data, this.memoryManager) : this.serializationService.convertData(data, dataType);
        if (convertedData instanceof NativeMemoryData && convertedData != data) {
            this.storageInfo.addUsedMemory(this.recordAccessor.getSize((NativeMemoryData)convertedData));
        }
        return convertedData;
    }

    @Override
    public void disposeData(Data data) {
        long size = 0L;
        if (data instanceof NativeMemoryData) {
            size = this.recordAccessor.getSize((NativeMemoryData)data);
        }
        this.serializationService.disposeData(data, this.memoryManager);
        this.storageInfo.removeUsedMemory(size);
    }

    @Override
    public long allocate(long size) {
        long address = this.memoryManager.allocate(size);
        this.storageInfo.addUsedMemory(this.getSize(address, size));
        return address;
    }

    @Override
    public void free(long address, long size) {
        long disposedSize = this.getSize(address, size);
        this.memoryManager.free(address, size);
        this.storageInfo.removeUsedMemory(disposedSize);
    }

    @Override
    public void addDeferredDispose(MemoryBlock memoryBlock) {
        if (memoryBlock.address() == 0L) {
            throw new IllegalArgumentException("Illegal address!");
        }
        this.deferredBlocksQueue.add(memoryBlock);
    }

    @Override
    public void disposeDeferredBlocks() {
        MemoryBlock block;
        while ((block = this.deferredBlocksQueue.poll()) != null) {
            if (block.address() == 0L) continue;
            if (block instanceof NativeMemoryData) {
                this.disposeData((NativeMemoryData)block);
                continue;
            }
            if (block instanceof HiDensityRecord) {
                this.dispose((R)((HiDensityRecord)block));
                continue;
            }
            this.memoryManager.free(block.address(), block.size());
        }
    }

    @Override
    public long getSize(MemoryBlock memoryBlock) {
        return this.recordAccessor.getSize(memoryBlock);
    }

    @Override
    public long getSize(long address, long expectedSize) {
        return this.recordAccessor.getSize(address, expectedSize);
    }

    @Override
    public MemoryAllocator unwrapMemoryAllocator() {
        return this.memoryManager.getSystemAllocator();
    }

    @Override
    public long getUsedMemory() {
        return this.storageInfo.getUsedMemory();
    }

    @Override
    public long increaseUsedMemory(long size) {
        return this.storageInfo.addUsedMemory(size);
    }

    @Override
    public long decreaseUsedMemory(long size) {
        return this.storageInfo.removeUsedMemory(size);
    }

    public HazelcastMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public EnterpriseSerializationService getSerializationService() {
        return this.serializationService;
    }

    public HiDensityStorageInfo getStorageInfo() {
        return this.storageInfo;
    }
}

