/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.queue;

import com.hazelcast.internal.elastic.LongIterator;
import com.hazelcast.internal.elastic.queue.LongBlockingQueue;
import com.hazelcast.internal.elastic.queue.LongConsumer;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class LongLinkedBlockingQueue
implements LongBlockingQueue {
    private static final long NULL_PTR = 0L;
    private static final int NODE_SIZE = 16;
    private static final int NEXT_OFFSET = 8;
    private final MemoryAllocator malloc;
    private final long nullItem;
    private final int capacity;
    private final boolean hasCapacity;
    private long head;
    private long tail;
    private final AtomicLong size = new AtomicLong();
    private final ReentrantLock headLock = new ReentrantLock();
    private final Condition notEmpty = this.headLock.newCondition();
    private final ReentrantLock tailLock = new ReentrantLock();
    private final Condition notFull = this.tailLock.newCondition();

    public LongLinkedBlockingQueue(MemoryAllocator malloc, long nullValue) {
        this(malloc, Integer.MAX_VALUE, nullValue);
    }

    public LongLinkedBlockingQueue(MemoryAllocator malloc, int capacity, long nullValue) {
        this.malloc = malloc;
        this.capacity = capacity;
        this.hasCapacity = capacity < Integer.MAX_VALUE;
        this.nullItem = nullValue;
        this.tail = this.head = this.newNode(this.nullItem);
    }

    private long newNode(long e) {
        long address = this.malloc.allocate(16L);
        GlobalMemoryAccessorRegistry.AMEM.putLong(null, address, e);
        GlobalMemoryAccessorRegistry.AMEM.putLong(null, address + 8L, 0L);
        return address;
    }

    private static long getItem(long node) {
        assert (node != 0L);
        return GlobalMemoryAccessorRegistry.AMEM.getLong(node);
    }

    private static long getNextNode(long node) {
        assert (node != 0L);
        return GlobalMemoryAccessorRegistry.AMEM.getLong(node + 8L);
    }

    private static void setNextNode(long node, long value) {
        assert (node != 0L);
        GlobalMemoryAccessorRegistry.AMEM.putLong(node + 8L, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(long value) {
        if (value == this.nullItem) {
            throw new IllegalArgumentException();
        }
        if (this.hasCapacity && this.size.get() == (long)this.capacity) {
            return false;
        }
        long c = -1L;
        this.tailLock.lock();
        try {
            if (this.tail == 0L) {
                throw new IllegalStateException("Queue is already disposed! " + this.toString());
            }
            if (!this.hasCapacity || this.size.get() < (long)this.capacity) {
                long node = this.newNode(value);
                LongLinkedBlockingQueue.setNextNode(this.tail, node);
                this.tail = node;
                c = this.size.getAndIncrement();
                if (c + 1L < (long)this.capacity) {
                    this.notFull.signal();
                }
            }
        }
        finally {
            this.tailLock.unlock();
        }
        if (c == 0L) {
            this.signalNotEmpty();
        }
        return c >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(long value, long timeout, TimeUnit unit) throws InterruptedException {
        if (value == this.nullItem) {
            throw new IllegalArgumentException();
        }
        long nanos = unit.toNanos(timeout);
        long c = -1L;
        this.tailLock.lock();
        try {
            if (this.tail == 0L) {
                throw new IllegalStateException("Queue is already destroyed! " + this.toString());
            }
            if (this.hasCapacity) {
                while (this.size.get() == (long)this.capacity) {
                    if (nanos <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    nanos = this.notFull.awaitNanos(nanos);
                }
            }
            long node = this.newNode(value);
            LongLinkedBlockingQueue.setNextNode(this.tail, node);
            this.tail = node;
            c = this.size.getAndIncrement();
            if (c + 1L < (long)this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            this.tailLock.unlock();
        }
        if (c == 0L) {
            this.signalNotEmpty();
        }
        return c >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(long value) throws InterruptedException {
        if (value == this.nullItem) {
            throw new IllegalArgumentException();
        }
        long c = -1L;
        this.tailLock.lock();
        try {
            if (this.tail == 0L) {
                throw new IllegalStateException("Queue is already destroyed! " + this.toString());
            }
            if (this.hasCapacity) {
                while (this.size.get() == (long)this.capacity) {
                    this.notFull.await();
                }
            }
            long node = this.newNode(value);
            LongLinkedBlockingQueue.setNextNode(this.tail, node);
            this.tail = node;
            c = this.size.getAndIncrement();
            if (c + 1L < (long)this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            this.tailLock.unlock();
        }
        if (c == 0L) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long poll() {
        long item;
        long node;
        long c = -1L;
        this.headLock.lock();
        try {
            if (this.head == 0L) {
                throw new IllegalStateException("Queue is already destroyed! " + this.toString());
            }
            node = this.head;
            long newHead = LongLinkedBlockingQueue.getNextNode(node);
            if (newHead == 0L) {
                long l = this.nullItem;
                return l;
            }
            item = LongLinkedBlockingQueue.getItem(newHead);
            this.head = newHead;
            c = this.size.getAndDecrement();
            if (c > 1L) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.headLock.unlock();
        }
        this.malloc.free(node, 16L);
        if (c == (long)this.capacity) {
            this.signalNotFull();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long poll(long timeout, TimeUnit unit) throws InterruptedException {
        long item;
        long node;
        long nanos = unit.toNanos(timeout);
        long c = -1L;
        this.headLock.lockInterruptibly();
        try {
            if (this.head == 0L) {
                throw new IllegalStateException("Queue is already destroyed! " + this.toString());
            }
            while (this.size.get() == 0L) {
                if (nanos <= 0L) {
                    long l = this.nullItem;
                    return l;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            node = this.head;
            long newHead = LongLinkedBlockingQueue.getNextNode(node);
            item = LongLinkedBlockingQueue.getItem(newHead);
            this.head = newHead;
            c = this.size.getAndDecrement();
            if (c > 1L) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.headLock.unlock();
        }
        this.malloc.free(node, 16L);
        if (c == (long)this.capacity) {
            this.signalNotFull();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long take() throws InterruptedException {
        long item;
        long node;
        long c = -1L;
        this.headLock.lockInterruptibly();
        try {
            if (this.head == 0L) {
                throw new IllegalStateException("Queue is already destroyed! " + this.toString());
            }
            while (this.size.get() == 0L) {
                this.notEmpty.await();
            }
            node = this.head;
            long newHead = LongLinkedBlockingQueue.getNextNode(node);
            item = LongLinkedBlockingQueue.getItem(newHead);
            this.head = newHead;
            c = this.size.getAndDecrement();
            if (c > 1L) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.headLock.unlock();
        }
        this.malloc.free(node, 16L);
        if (c == (long)this.capacity) {
            this.signalNotFull();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(LongConsumer consumer) {
        ReentrantLock lock = this.headLock;
        lock.lock();
        try {
            long node;
            long newHead;
            long item;
            long c = this.size.get();
            while (c > 0L && consumer.consume(item = LongLinkedBlockingQueue.getItem(newHead = LongLinkedBlockingQueue.getNextNode(node = this.head)))) {
                this.head = newHead;
                c = this.size.decrementAndGet();
                this.malloc.free(node, 16L);
            }
            if (c > 0L) {
                this.notEmpty.signal();
            }
        }
        finally {
            lock.unlock();
        }
        this.signalNotFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long peek() {
        if (this.size.get() == 0L) {
            return this.nullItem;
        }
        this.headLock.lock();
        try {
            if (this.head == 0L) {
                throw new IllegalStateException("Queue is already destroyed! " + this.toString());
            }
            long first = LongLinkedBlockingQueue.getNextNode(this.head);
            if (first == 0L) {
                long l = this.nullItem;
                return l;
            }
            long l = LongLinkedBlockingQueue.getItem(first);
            return l;
        }
        finally {
            this.headLock.unlock();
        }
    }

    @Override
    public int size() {
        long c = this.size.get();
        return c < Integer.MAX_VALUE ? (int)c : Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0L;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int remainingCapacity() {
        return this.hasCapacity ? this.capacity - this.size() : Integer.MAX_VALUE;
    }

    @Override
    public void clear() {
        this.fullLock();
        try {
            while (this.poll() != this.nullItem) {
            }
        }
        finally {
            this.fullUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.fullLock();
        try {
            if (this.head != 0L) {
                this.clear();
                long headPtr = this.head;
                long tailPtr = this.tail;
                this.head = 0L;
                this.tail = 0L;
                assert (headPtr == tailPtr);
                if (headPtr != 0L) {
                    this.malloc.free(headPtr, 16L);
                }
            }
        }
        finally {
            this.fullUnlock();
        }
    }

    @Override
    public long nullItem() {
        return this.nullItem;
    }

    @Override
    public LongIterator iterator() {
        throw new UnsupportedOperationException();
    }

    private void signalNotEmpty() {
        this.headLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.headLock.unlock();
        }
    }

    private void signalNotFull() {
        this.tailLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            this.tailLock.unlock();
        }
    }

    private void fullUnlock() {
        this.tailLock.unlock();
        this.headLock.unlock();
    }

    private void fullLock() {
        this.headLock.lock();
        this.tailLock.lock();
    }

    public String toString() {
        return "LongLinkedBlockingQueue{capacity=" + this.capacity + ", size=" + this.size.get() + '}';
    }
}

