/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.queue;

import com.hazelcast.internal.elastic.LongIterator;
import com.hazelcast.internal.elastic.queue.LongArrayQueue;
import com.hazelcast.internal.elastic.queue.LongQueue;
import com.hazelcast.internal.memory.GarbageCollectable;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class LongConcurrentLinkedQueue
implements LongQueue,
GarbageCollectable {
    private static final long NULL_PTR = 0L;
    private static final int NODE_SIZE = 16;
    private static final int NEXT_OFFSET = 8;
    private static final int DEFAULT_THREAD_LOCAL_ADDRESS_CAPACITY = 1024;
    private final MemoryAllocator malloc;
    private final long nullItem;
    private final AtomicLong head;
    private final AtomicLong tail;
    private final AtomicLong size = new AtomicLong();
    private final int threadLocalAddressCapacity;
    private final ConcurrentHashMap<Thread, LocalAddressQueue> localAddressQueues = new ConcurrentHashMap();

    public LongConcurrentLinkedQueue(MemoryAllocator malloc, long nullValue) {
        this(malloc, nullValue, 1024);
    }

    public LongConcurrentLinkedQueue(MemoryAllocator malloc, long nullValue, int threadLocalAddressCapacity) {
        this.malloc = malloc;
        this.threadLocalAddressCapacity = threadLocalAddressCapacity;
        this.nullItem = nullValue;
        long address = malloc.allocate(16L);
        LongConcurrentLinkedQueue.setNode(address, this.nullItem);
        this.head = new AtomicLong(address);
        this.tail = new AtomicLong(this.head.get());
    }

    private long newNode(long e) {
        LocalAddressQueue queue = this.getLocalAddressQueue();
        long address = queue.allocate();
        LongConcurrentLinkedQueue.setNode(address, e);
        return address;
    }

    private static void setNode(long address, long e) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(null, address, e);
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(null, address + 8L, 0L);
    }

    private static long getItem(long node) {
        Preconditions.checkNotNull("Node is null!");
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(null, node);
    }

    private static long getNextNode(long node) {
        Preconditions.checkNotNull("Node is null!");
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(null, node + 8L);
    }

    private static boolean casNextNode(long node, long current, long value) {
        Preconditions.checkNotNull("Node is null!");
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(null, node + 8L, current, value);
    }

    @Override
    public boolean offer(long value) {
        long t;
        if (value == this.nullItem) {
            throw new IllegalArgumentException("attempt to offer the 'value missing' sentinel");
        }
        long node = this.newNode(value);
        while (true) {
            if ((t = this.tail.get()) == 0L) {
                throw new IllegalStateException("Queue is already destroyed! " + this.toString());
            }
            long next = LongConcurrentLinkedQueue.getNextNode(t);
            if (t != this.tail.get()) continue;
            if (next == 0L) {
                if (!LongConcurrentLinkedQueue.casNextNode(t, 0L, node)) continue;
                break;
            }
            this.tail.compareAndSet(t, next);
        }
        this.tail.compareAndSet(t, node);
        this.size.incrementAndGet();
        return true;
    }

    @Override
    public long poll() {
        long item;
        long h;
        while (true) {
            if ((h = this.head.get()) == 0L) {
                throw new IllegalStateException("Queue is already destroyed! " + this.toString());
            }
            long t = this.tail.get();
            long next = LongConcurrentLinkedQueue.getNextNode(h);
            if (h != this.head.get()) continue;
            if (h == t) {
                if (next == 0L) {
                    return this.nullItem;
                }
                this.tail.compareAndSet(t, next);
                continue;
            }
            item = LongConcurrentLinkedQueue.getItem(next);
            if (this.head.compareAndSet(h, next)) break;
        }
        LocalAddressQueue queue = this.getLocalAddressQueue();
        queue.free(h);
        this.size.decrementAndGet();
        return item;
    }

    @SuppressFBWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="since the map key is the current thread, concurrent access is impossible at the same key")
    private LocalAddressQueue getLocalAddressQueue() {
        Thread t = Thread.currentThread();
        LocalAddressQueue queue = this.localAddressQueues.get(t);
        if (queue == null) {
            queue = new LocalAddressQueue();
            this.localAddressQueues.put(t, queue);
        }
        return queue;
    }

    @Override
    public long peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        long c = this.size.get();
        return c < Integer.MAX_VALUE ? (int)c : Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0L;
    }

    @Override
    public int capacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void clear() {
        while (this.poll() != this.nullItem) {
        }
    }

    @Override
    public long nullItem() {
        return this.nullItem;
    }

    @Override
    public void dispose() {
        if (!this.isDestroyed()) {
            this.clear();
            long ptr = this.head.getAndSet(0L);
            long ptr2 = this.tail.getAndSet(0L);
            assert (ptr == ptr2);
            if (ptr != 0L) {
                this.malloc.free(ptr, 16L);
            }
        }
        if (!this.localAddressQueues.isEmpty()) {
            Iterator<LocalAddressQueue> iter = this.localAddressQueues.values().iterator();
            while (iter.hasNext()) {
                LocalAddressQueue q = iter.next();
                iter.remove();
                q.destroy();
            }
        }
    }

    public boolean isDestroyed() {
        return this.head.get() == 0L;
    }

    @Override
    public void gc() {
        if (!this.localAddressQueues.isEmpty()) {
            Iterator<Map.Entry<Thread, LocalAddressQueue>> iter = this.localAddressQueues.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Thread, LocalAddressQueue> entry = iter.next();
                if (entry.getKey().isAlive()) continue;
                iter.remove();
                entry.getValue().destroy();
            }
        }
    }

    @Override
    public LongIterator iterator() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "LongConcurrentLinkedQueue{head=" + this.head + ", tail=" + this.tail + ", size=" + this.size + '}';
    }

    private class LocalAddressQueue {
        private final AtomicBoolean valid = new AtomicBoolean(true);
        private final LongArrayQueue queue = new LongArrayQueue(LongConcurrentLinkedQueue.access$100(LongConcurrentLinkedQueue.this), LongConcurrentLinkedQueue.access$200(LongConcurrentLinkedQueue.this), 0L);

        private LocalAddressQueue() {
        }

        void free(long ptr) {
            assert (ptr != 0L);
            if (!this.queue.offer(ptr)) {
                long l = this.queue.poll();
                this.queue.offer(ptr);
                if (l != 0L) {
                    LongConcurrentLinkedQueue.this.malloc.free(l, 16L);
                }
            }
        }

        long allocate() {
            long thresholdRatio = 4L;
            long ptr = (long)this.queue.size() > (long)LongConcurrentLinkedQueue.this.threadLocalAddressCapacity / 4L ? this.queue.poll() : 0L;
            return ptr == 0L ? LongConcurrentLinkedQueue.this.malloc.allocate(16L) : ptr;
        }

        void destroy() {
            if (this.valid.compareAndSet(true, false)) {
                if (this.queue.size() > 0) {
                    long l;
                    while ((l = this.queue.poll()) != 0L) {
                        LongConcurrentLinkedQueue.this.malloc.free(l, 16L);
                    }
                }
                this.queue.dispose();
            }
        }
    }
}

