/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.map;

import com.hazelcast.internal.elastic.map.BinaryElasticHashMap;
import com.hazelcast.internal.elastic.map.ElasticMap;
import com.hazelcast.internal.elastic.map.NativeBehmSlotAccessorFactory;
import com.hazelcast.internal.elastic.map.NativeMemoryDataAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class ElasticHashMap<K, V>
implements ElasticMap<K, V> {
    private final BinaryElasticHashMap<NativeMemoryData> map;
    private final EnterpriseSerializationService ss;

    public ElasticHashMap(EnterpriseSerializationService ss, MemoryAllocator malloc) {
        this(16, 0.6f, ss, malloc);
    }

    public ElasticHashMap(int initialCapacity, float loadFactor, EnterpriseSerializationService ss, MemoryAllocator malloc) {
        this.ss = ss;
        this.map = new BinaryElasticHashMap<NativeMemoryData>(initialCapacity, loadFactor, ss, new NativeBehmSlotAccessorFactory(), new NativeMemoryDataAccessor(ss), malloc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        NativeMemoryData v;
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        NativeMemoryData old = this.map.put(k, v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE));
        if (old != null) {
            try {
                Object t = this.ss.toObject(old);
                return (V)t;
            }
            finally {
                this.ss.disposeData(old);
            }
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean set(K key, V value) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        NativeMemoryData v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE);
        return this.map.set(k, v);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        NativeMemoryData v;
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        NativeMemoryData current = this.map.putIfAbsent(k, v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE));
        if (current != null) {
            this.ss.disposeData(k);
            this.ss.disposeData(v);
            return (V)this.ss.toObject(current);
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        NativeMemoryData o = (NativeMemoryData)this.ss.toData(oldValue, DataType.NATIVE);
        NativeMemoryData n = (NativeMemoryData)this.ss.toData(newValue, DataType.NATIVE);
        boolean replaced = this.map.replace(k, o, n);
        this.ss.disposeData(k);
        this.ss.disposeData(o);
        if (!replaced) {
            this.ss.disposeData(n);
        }
        return replaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        NativeMemoryData v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE);
        NativeMemoryData old = this.map.replace(k, v);
        this.ss.disposeData(k);
        if (old != null) {
            try {
                Object t = this.ss.toObject(old);
                return (V)t;
            }
            finally {
                this.ss.disposeData(old);
            }
        }
        this.ss.disposeData(v);
        return null;
    }

    @Override
    public V get(Object key) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        NativeMemoryData v = (NativeMemoryData)this.map.get(k);
        this.ss.disposeData(k);
        return v != null ? (V)this.ss.toObject(v) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        NativeMemoryData old = (NativeMemoryData)this.map.remove(k);
        this.ss.disposeData(k);
        if (old != null) {
            try {
                Object t = this.ss.toObject(old);
                return (V)t;
            }
            finally {
                this.ss.disposeData(old);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(K key) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        try {
            boolean bl = this.map.delete(k);
            return bl;
        }
        finally {
            this.ss.disposeData(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        NativeMemoryData v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE);
        try {
            boolean bl = this.map.remove(k, v);
            return bl;
        }
        finally {
            this.ss.disposeData(k);
            this.ss.disposeData(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        NativeMemoryData k = (NativeMemoryData)this.ss.toData(key, DataType.NATIVE);
        try {
            boolean bl = this.map.containsKey(k);
            return bl;
        }
        finally {
            this.ss.disposeData(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        NativeMemoryData v = (NativeMemoryData)this.ss.toData(value, DataType.NATIVE);
        try {
            boolean bl = this.map.containsValue(v);
            return bl;
        }
        finally {
            this.ss.disposeData(v);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void dispose() {
        this.map.dispose();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

