/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.util.collection.HsaHeapMemoryManager;
import com.hazelcast.internal.util.collection.LongCursor;
import com.hazelcast.internal.util.collection.LongSet;
import com.hazelcast.internal.util.collection.LongSetHsa;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import java.util.function.LongConsumer;

public class LockingContext {
    private final LongSet locks = new LongSetHsa(0L, new HsaHeapMemoryManager());
    private final LongSet pins = new LongSetHsa(0L, new HsaHeapMemoryManager());
    private long lastUnpinnedAddress = -1L;
    private PartitionIdSet registeredPartitions;

    LockingContext() {
    }

    void addLock(long lockAddr) {
        this.locks.add(lockAddr);
    }

    void removeLock(long lockAddr) {
        this.locks.remove(lockAddr);
    }

    void releaseLocks(LockManager lockManager) {
        LongCursor cursor = this.locks.cursor();
        while (cursor.advance()) {
            long lockAddr = cursor.value();
            lockManager.releaseLock(lockAddr);
        }
        this.locks.clear();
    }

    boolean hasNoLocksAndPins() {
        return this.locks.isEmpty() && this.pins.isEmpty();
    }

    boolean hasNoUnpinnedAddress() {
        return this.lastUnpinnedAddress == -1L;
    }

    long replaceAddressToPin(long nodeAddr) {
        long addressToPin = this.lastUnpinnedAddress;
        this.lastUnpinnedAddress = nodeAddr;
        return addressToPin;
    }

    long consumeAddressToUnpin(long nodeAddr) {
        assert (nodeAddr > 0L);
        long lastUnpinnedAddress = Math.abs(this.lastUnpinnedAddress);
        assert (lastUnpinnedAddress == nodeAddr || this.pins.contains(nodeAddr));
        if (nodeAddr == lastUnpinnedAddress) {
            this.lastUnpinnedAddress = -1L;
            return -1L;
        }
        return nodeAddr;
    }

    boolean isPinned(long nodeAddr) {
        assert (nodeAddr > 0L);
        long lastUnpinnedAddress = Math.abs(this.lastUnpinnedAddress);
        assert (lastUnpinnedAddress == nodeAddr || this.pins.contains(nodeAddr));
        return lastUnpinnedAddress != nodeAddr;
    }

    void addPin(long nodeAddr) {
        assert (nodeAddr > 0L);
        this.pins.add(nodeAddr);
    }

    void removePin(long nodeAddr) {
        assert (nodeAddr > 0L);
        this.pins.remove(nodeAddr);
    }

    void releasePins(LongConsumer releaser) {
        LongCursor cursor = this.pins.cursor();
        while (cursor.advance()) {
            long nodeAddr = cursor.value();
            releaser.accept(nodeAddr);
        }
        this.pins.clear();
    }

    void addPartition(int partitionId, TStoreAllocator allocator) {
        if (this.registeredPartitions == null) {
            this.registeredPartitions = allocator.newPartitionIdSet();
        }
        this.registeredPartitions.add(partitionId);
    }

    boolean hasPartition(int partitionId) {
        return this.registeredPartitions == null ? false : this.registeredPartitions.contains(partitionId);
    }

    PartitionIdSet getPartitions() {
        return this.registeredPartitions;
    }

    void clearPartitions() {
        this.registeredPartitions.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LockingContext{ ");
        builder.append(" locks { ");
        LongCursor lockCursor = this.locks.cursor();
        while (lockCursor.advance()) {
            long lockAddr = lockCursor.value();
            builder.append(lockAddr);
            builder.append(" ");
        }
        builder.append(" } ");
        builder.append(" pins { ");
        LongCursor pinCursor = this.pins.cursor();
        while (pinCursor.advance()) {
            long pin = pinCursor.value();
            builder.append(pin);
            builder.append(" ");
        }
        builder.append(" } ");
        builder.append("}");
        return builder.toString();
    }
}

