/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

public final class DefaultBPlusTreeKeyAccessor
implements BPlusTreeKeyAccessor {
    private final EnterpriseSerializationService ess;

    public DefaultBPlusTreeKeyAccessor(EnterpriseSerializationService ess) {
        this.ess = ess;
    }

    @Override
    public long convertToNativeData(Comparable indexKey, MemoryAllocator memoryAllocator) {
        NativeMemoryData data = (NativeMemoryData)this.ess.toNativeData(indexKey, memoryAllocator);
        return data.address();
    }

    @Override
    public Comparable convertToObject(long address) {
        NativeMemoryData indexKeyData = new NativeMemoryData().reset(address);
        return (Comparable)this.ess.toObject(indexKeyData);
    }

    @Override
    public Data convertToHeapData(long address) {
        NativeMemoryData indexKeyData = new NativeMemoryData().reset(address);
        return this.ess.toData((Object)indexKeyData, DataType.HEAP);
    }

    @Override
    public long convertToNativeData(long address, MemoryAllocator memoryAllocator) {
        NativeMemoryData indexKeyData = new NativeMemoryData().reset(address);
        return DefaultBPlusTreeKeyAccessor.cloneNativeMemory(indexKeyData, memoryAllocator).address();
    }

    @Override
    public void disposeNativeData(long address, MemoryAllocator memoryAllocator) {
        NativeMemoryData data = new NativeMemoryData().reset(address);
        this.ess.disposeData(data, memoryAllocator);
    }

    static NativeMemoryData cloneNativeMemory(NativeMemoryData data, MemoryAllocator memoryAllocator) {
        long address = memoryAllocator.allocate(data.size());
        data.copyTo(0L, null, address, data.size());
        return new NativeMemoryData(address, data.size());
    }
}

