/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.Config;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImpl;
import com.hazelcast.internal.util.MD5Util;
import com.hazelcast.internal.util.phonehome.PhoneHome;
import com.hazelcast.internal.util.phonehome.PhoneHomeParameterCreator;
import com.hazelcast.license.domain.License;
import com.hazelcast.memory.MemoryUnit;

public class EnterprisePhoneHome
extends PhoneHome {
    public EnterprisePhoneHome(Node hazelcastNode) {
        super(hazelcastNode);
    }

    @Override
    public PhoneHomeParameterCreator createParameters() {
        PhoneHomeParameterCreator parameters = super.createParameters();
        ClusterServiceImpl clusterService = this.hazelcastNode.getClusterService();
        Config config = this.hazelcastNode.getConfig();
        NativeMemoryConfig memoryConfig = config.getNativeMemoryConfig();
        long totalNativeMemorySize = (long)clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR) * memoryConfig.getSize().bytes();
        String nativeMemoryParameter = Long.toString(MemoryUnit.BYTES.toGigaBytes(totalNativeMemorySize));
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.hazelcastNode.getNodeExtension();
        License license = nodeExtension.getLicense();
        String licenseKey = license.getKey();
        String keyHash = licenseKey != null ? MD5Util.toMD5String(licenseKey) : "";
        boolean isLicenseOEM = license.isOem();
        boolean tieredStorageEnabled = config.getMapConfigs().values().stream().anyMatch(mapConfig -> mapConfig.getTieredStoreConfig().isEnabled());
        parameters.addParam("e", "true");
        parameters.addParam("l", keyHash);
        parameters.addParam("oem", Boolean.toString(isLicenseOEM));
        parameters.addParam("hdgb", nativeMemoryParameter);
        parameters.addParam("lkv", license.getVersion().name());
        parameters.addParam("tsl", String.valueOf(license.getAllowedTieredStoreSize()));
        if (tieredStorageEnabled) {
            TieredStoreServiceImpl tieredStoreService = (TieredStoreServiceImpl)this.hazelcastNode.getNodeEngine().getService("hz:ee:tieredStoreServiceImpl");
            long hlogLength = tieredStoreService.getMetrics().getPerMemberMetrics().getHlogLengthExposer();
            parameters.addParam("tsh", String.valueOf(hlogLength));
        }
        return parameters;
    }
}

