/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.cluster.Address;
import com.hazelcast.enterprise.wan.impl.connection.WanConnectionManager;
import com.hazelcast.enterprise.wan.impl.connection.WanConnectionWrapper;
import com.hazelcast.enterprise.wan.impl.operation.WanEventContainerOperation;
import com.hazelcast.enterprise.wan.impl.operation.WanProtocolNegotiationResponse;
import com.hazelcast.enterprise.wan.impl.replication.WanBatchPublisher;
import com.hazelcast.enterprise.wan.impl.replication.WanBatchSender;
import com.hazelcast.enterprise.wan.impl.replication.WanConfigurationContext;
import com.hazelcast.enterprise.wan.impl.replication.WanEventBatch;
import com.hazelcast.enterprise.wan.impl.replication.compact.WanCompactSchemaReplicationManager;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.serialization.impl.compact.schema.EnterpriseMemberSchemaService;
import com.hazelcast.internal.server.ServerConnectionManager;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.version.Version;
import java.util.concurrent.Executor;

public class DefaultWanBatchSender
implements WanBatchSender {
    private WanConnectionManager connectionManager;
    private OperationService operationService;
    private WanConfigurationContext configurationContext;
    private Executor wanExecutor;
    private WanCompactSchemaReplicationManager wanCompactSchemaReplicationManager;

    @Override
    public void init(Node node, WanBatchPublisher publisher) {
        this.connectionManager = publisher.getConnectionManager();
        this.operationService = node.getNodeEngine().getOperationService();
        this.configurationContext = publisher.getConfigurationContext();
        this.wanExecutor = publisher.getWanExecutor();
        this.wanCompactSchemaReplicationManager = ((EnterpriseMemberSchemaService)node.getSchemaService()).getWanCompactSchemaReplicationManager();
    }

    @Override
    public InternalCompletableFuture<Boolean> send(WanEventBatch batchReplicationEvent, Address target) {
        WanConnectionWrapper connectionWrapper = this.connectionManager.getConnection(target);
        if (connectionWrapper != null) {
            WanProtocolNegotiationResponse negotiationResponse = connectionWrapper.getNegotiationResponse();
            Version protocolVersion = negotiationResponse.getChosenWanProtocolVersion();
            this.wanCompactSchemaReplicationManager.addNotYetReplicatedSchemasToEvent(batchReplicationEvent, negotiationResponse);
            return this.invokeOnWanTarget(connectionWrapper, batchReplicationEvent, protocolVersion);
        }
        return InternalCompletableFuture.newCompletedFuture((Object)false, this.wanExecutor);
    }

    private InternalCompletableFuture<Boolean> invokeOnWanTarget(WanConnectionWrapper connectionWrapper, IdentifiedDataSerializable event, Version wanProtocolVersion) {
        ServerConnectionManager endpointManager = connectionWrapper.getConnection().getConnectionManager();
        Address targetAddress = connectionWrapper.getTargetAddress();
        WanEventContainerOperation wanOperation = new WanEventContainerOperation(event, this.configurationContext.getAcknowledgeType(), wanProtocolVersion);
        String serviceName = "hz:core:wanReplicationService";
        return this.operationService.createInvocationBuilder(serviceName, (Operation)wanOperation, targetAddress).setTryCount(1).setConnectionManager(endpointManager).invoke();
    }
}

