/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.enterprise.wan.impl.operation.WanProtocolNegotiationStatus;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.version.MemberVersion;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.Map;

public class WanProtocolNegotiationResponse
implements IdentifiedDataSerializable {
    private WanProtocolNegotiationStatus status;
    private MemberVersion memberVersion;
    private Version clusterVersion;
    private Version chosenWanProtocolVersion;
    private Map<String, String> metadata;

    public WanProtocolNegotiationResponse() {
    }

    public WanProtocolNegotiationResponse(WanProtocolNegotiationStatus status, MemberVersion memberVersion, Version clusterVersion, Version chosenWanProtocolVersion, Map<String, String> metadata) {
        this.status = status;
        this.memberVersion = memberVersion;
        this.clusterVersion = clusterVersion;
        this.chosenWanProtocolVersion = chosenWanProtocolVersion;
        this.metadata = metadata;
    }

    public WanProtocolNegotiationStatus getStatus() {
        return this.status;
    }

    public Version getChosenWanProtocolVersion() {
        return this.chosenWanProtocolVersion;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 25;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByte(this.status.getStatusCode());
        out.writeObject(this.memberVersion);
        out.writeObject(this.clusterVersion);
        out.writeObject(this.chosenWanProtocolVersion);
        out.writeInt(this.metadata.size());
        for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.status = WanProtocolNegotiationStatus.getByType(in.readByte());
        this.memberVersion = (MemberVersion)in.readObject();
        this.clusterVersion = (Version)in.readObject();
        this.chosenWanProtocolVersion = (Version)in.readObject();
        int metadataSize = in.readInt();
        this.metadata = MapUtil.createHashMap(metadataSize);
        for (int i = 0; i < metadataSize; ++i) {
            this.metadata.put(in.readString(), in.readString());
        }
    }
}

