/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.enterprise.wan.impl.operation.WanProtocolNegotiationResponse;
import com.hazelcast.enterprise.wan.impl.operation.WanProtocolNegotiationStatus;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.version.MemberVersion;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class WanProtocolNegotiationOperation
extends Operation
implements JoinOperation {
    private List<Version> sourceWanProtocolVersions;
    private String sourceClusterName;
    private String targetClusterName;
    private WanProtocolNegotiationResponse response;

    public WanProtocolNegotiationOperation() {
    }

    public WanProtocolNegotiationOperation(String sourceClusterName, String targetClusterName, List<Version> sourceWanProtocolVersions) {
        this.sourceClusterName = sourceClusterName;
        this.targetClusterName = targetClusterName;
        this.sourceWanProtocolVersions = sourceWanProtocolVersions;
    }

    @Override
    public void run() {
        MemberVersion memberVersion = this.getNodeEngine().getLocalMember().getVersion();
        Version clusterVersion = this.getNodeEngine().getClusterService().getClusterVersion();
        if (!this.targetClusterName.equals(this.getNodeEngine().getConfig().getClusterName())) {
            String failureCause = String.format("WAN protocol negotiation from (%s,%s) failed because of cluster name mismatch. ", this.sourceClusterName, this.getCallerAddress());
            this.getLogger().info(failureCause);
            this.response = new WanProtocolNegotiationResponse(WanProtocolNegotiationStatus.CLUSTER_NAME_MISMATCH, memberVersion, clusterVersion, null, Collections.emptyMap());
            return;
        }
        List<Version> localProtocolVersions = this.getNodeEngine().getWanReplicationService().getSupportedWanProtocolVersions();
        Optional<Version> chosenProtocolVersion = localProtocolVersions.stream().filter(this.sourceWanProtocolVersions::contains).findFirst();
        if (!chosenProtocolVersion.isPresent()) {
            String failureCause = String.format("WAN protocol negotiation from (%s , %s) failed because no matching WAN protocol versions were found. Source member supports %s, target supports %s", this.sourceClusterName, this.getCallerAddress(), this.sourceWanProtocolVersions, localProtocolVersions);
            this.getLogger().info(failureCause);
            this.response = new WanProtocolNegotiationResponse(WanProtocolNegotiationStatus.PROTOCOL_MISMATCH, memberVersion, clusterVersion, null, Collections.emptyMap());
            return;
        }
        if (this.getLogger().isFineEnabled()) {
            this.getLogger().fine(String.format("WAN protocol version %s is chosen to be used in the WAN connection from (%s , %s). Source member supports %s, target supports %s", chosenProtocolVersion.get(), this.sourceClusterName, this.getCallerAddress(), this.sourceWanProtocolVersions, localProtocolVersions));
        }
        this.response = new WanProtocolNegotiationResponse(WanProtocolNegotiationStatus.OK, memberVersion, clusterVersion, chosenProtocolVersion.get(), this.getMetadata());
    }

    private Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>(1);
        UUID clusterId = this.getNodeEngine().getClusterService().getClusterId();
        if (clusterId != null) {
            metadata.put("clusterId", clusterId.toString());
        }
        return metadata;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.sourceClusterName = in.readString();
        this.targetClusterName = in.readString();
        int sourceWanProtocolVersionSize = in.readInt();
        this.sourceWanProtocolVersions = new ArrayList<Version>(sourceWanProtocolVersionSize);
        for (int i = 0; i < sourceWanProtocolVersionSize; ++i) {
            this.sourceWanProtocolVersions.add((Version)in.readObject());
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.sourceClusterName);
        out.writeString(this.targetClusterName);
        out.writeInt(this.sourceWanProtocolVersions.size());
        for (Version version : this.sourceWanProtocolVersions) {
            out.writeObject(version);
        }
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 24;
    }
}

