/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.enterprise.wan.impl.replication.compact.WanCompactSchemaReplicationManager;
import com.hazelcast.internal.cluster.impl.operations.WanOperation;
import com.hazelcast.internal.serialization.impl.compact.schema.EnterpriseMemberSchemaService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WanAcknowledgeCompactSchemaReplicationsOperation
extends Operation
implements WanOperation,
IdentifiedDataSerializable,
AllowedDuringPassiveState {
    private String clusterId;
    private List<Long> schemaIds;

    public WanAcknowledgeCompactSchemaReplicationsOperation() {
    }

    public WanAcknowledgeCompactSchemaReplicationsOperation(String clusterId, List<Long> schemaIds) {
        this.clusterId = clusterId;
        this.schemaIds = schemaIds;
    }

    @Override
    public void run() throws Exception {
        EnterpriseMemberSchemaService schemaService = (EnterpriseMemberSchemaService)this.getNodeEngine().getSchemaService();
        WanCompactSchemaReplicationManager replicationManager = schemaService.getWanCompactSchemaReplicationManager();
        replicationManager.onSchemaReplicationAcknowledgment(this.clusterId, this.schemaIds);
        super.run();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.clusterId = in.readString();
        int itemCount = in.readInt();
        ArrayList<Long> schemaIds = new ArrayList<Long>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            schemaIds.add(in.readLong());
        }
        this.schemaIds = schemaIds;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.clusterId);
        out.writeInt(this.schemaIds.size());
        for (long schemaId : this.schemaIds) {
            out.writeLong(schemaId);
        }
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 26;
    }
}

