/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.enterprise.wan.impl.DistributedObjectIdentifier;
import com.hazelcast.enterprise.wan.impl.operation.WanBaseOperation;
import com.hazelcast.enterprise.wan.impl.replication.AbstractWanPublisher;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.Map;

public class RemoveWanEventBackupsOperation
extends WanBaseOperation
implements BackupOperation,
IdentifiedDataSerializable,
AllowedDuringPassiveState {
    private Map<DistributedObjectIdentifier, Integer> eventCounts;

    public RemoveWanEventBackupsOperation() {
    }

    public RemoveWanEventBackupsOperation(String wanReplicationName, String targetName, Map<DistributedObjectIdentifier, Integer> eventCounts) {
        super(wanReplicationName, targetName);
        this.eventCounts = eventCounts;
    }

    @Override
    public void run() throws Exception {
        AbstractWanPublisher publisher = (AbstractWanPublisher)this.getEWRService().getPublisherOrNull(this.wanReplicationName, this.wanPublisherId);
        if (publisher != null) {
            for (Map.Entry<DistributedObjectIdentifier, Integer> eventCountEntry : this.eventCounts.entrySet()) {
                DistributedObjectIdentifier id = eventCountEntry.getKey();
                int count = eventCountEntry.getValue();
                if (id.getTotalBackupCount() < this.getReplicaIndex()) continue;
                publisher.removeWanEvents(this.getPartitionId(), id.getServiceName(), id.getObjectName(), count);
            }
        } else {
            this.getLogger().finest("Ignoring backup since WAN config doesn't exist with config name " + this.wanReplicationName + " and publisher ID " + this.wanPublisherId);
        }
        this.response = true;
    }

    @Override
    public int getClassId() {
        return 23;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.eventCounts.size());
        for (Map.Entry<DistributedObjectIdentifier, Integer> eventCountEntry : this.eventCounts.entrySet()) {
            DistributedObjectIdentifier id = eventCountEntry.getKey();
            Integer count = eventCountEntry.getValue();
            out.writeString(id.getServiceName());
            out.writeString(id.getObjectName());
            out.writeInt(id.getTotalBackupCount());
            out.writeInt(count);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int eventCountSize = in.readInt();
        this.eventCounts = MapUtil.createHashMap(eventCountSize);
        for (int i = 0; i < eventCountSize; ++i) {
            String serviceName = in.readString();
            String objectName = in.readString();
            int totalBackupCount = in.readInt();
            int eventCount = in.readInt();
            this.eventCounts.put(new DistributedObjectIdentifier(serviceName, objectName, totalBackupCount), eventCount);
        }
    }
}

