/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.AbstractWanAntiEntropyEvent;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.wan.impl.WanSyncType;
import java.io.IOException;
import java.util.UUID;

public class WanSyncEvent
extends AbstractWanAntiEntropyEvent
implements IdentifiedDataSerializable {
    private WanSyncType type;

    public WanSyncEvent() {
    }

    public WanSyncEvent(WanSyncType type) {
        assert (type == WanSyncType.ALL_MAPS);
        this.assignUuid();
        this.type = type;
    }

    public WanSyncEvent(WanSyncType type, String name) {
        super(name);
        this.type = type;
    }

    private WanSyncEvent(WanSyncType type, UUID uuid, String name) {
        super(uuid, name);
        this.type = type;
    }

    @Override
    public AbstractWanAntiEntropyEvent cloneWithoutPartitionKeys() {
        return new WanSyncEvent(this.type, this.uuid, this.mapName);
    }

    public WanSyncType getType() {
        return this.type;
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 13;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.type.getType());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.type = WanSyncType.getByType(in.readInt());
    }

    public String toString() {
        return "WanSyncEvent{type=" + (Object)((Object)this.type) + ", mapName='" + this.mapName + '\'' + ", partitionSet=" + this.partitionSet + '}';
    }
}

