/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.enterprise.wan.impl.FinalizableEnterpriseWanEvent;
import com.hazelcast.enterprise.wan.impl.PartitionWanEventContainer;
import com.hazelcast.enterprise.wan.impl.PartitionWanEventQueueMap;
import com.hazelcast.enterprise.wan.impl.WanEventMigrationContainer;
import com.hazelcast.enterprise.wan.impl.WanEventQueue;
import com.hazelcast.enterprise.wan.impl.replication.WanConfigurationContext;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.wan.impl.InternalWanEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class PublisherQueueContainer {
    private final PartitionWanEventContainer[] containers;

    public PublisherQueueContainer(Node node, WanConfigurationContext configurationContext) {
        int partitionCount = node.getPartitionService().getPartitionCount();
        int batchSize = configurationContext.getBatchSize();
        int maxConcurrentInvocations = configurationContext.getMaxConcurrentInvocations();
        int maxInFlightEvents = Math.max(Math.max(maxConcurrentInvocations, 1) * batchSize, 2);
        this.containers = new PartitionWanEventContainer[partitionCount];
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            this.containers[partitionId] = new PartitionWanEventContainer(maxInFlightEvents);
        }
    }

    public InternalWanEvent pollCacheWanEvent(String nameWithPrefix, int partitionId) {
        return this.getEventQueue(partitionId).pollCacheWanEvent(nameWithPrefix);
    }

    public boolean publishCacheWanEvent(String nameWithPrefix, int partitionId, FinalizableEnterpriseWanEvent replicationEvent) {
        return this.getEventQueue(partitionId).publishCacheWanEvent(nameWithPrefix, replicationEvent);
    }

    public InternalWanEvent pollMapWanEvent(String mapName, int partitionId) {
        return this.getEventQueue(partitionId).pollMapWanEvent(mapName);
    }

    public boolean publishMapWanEvent(String mapName, int partitionId, FinalizableEnterpriseWanEvent replicationEvent) {
        return this.getEventQueue(partitionId).publishMapWanEvent(mapName, replicationEvent);
    }

    public void drainRandomWanQueue(int partitionId, Collection<FinalizableEnterpriseWanEvent> drainTo, int elementsToDrain) {
        this.getEventQueue(partitionId).drainRandomWanQueue(drainTo, elementsToDrain);
    }

    public PartitionWanEventContainer getEventQueue(int partitionId) {
        return this.containers[partitionId];
    }

    public int size(int partitionId) {
        return this.getEventQueue(partitionId).size();
    }

    public Map<Integer, Integer> drainQueues() {
        Map<Integer, Integer> partitionDrainsMap = MapUtil.createHashMap(this.containers.length);
        for (int partitionId = 0; partitionId < this.containers.length; ++partitionId) {
            PartitionWanEventContainer partitionWanEventContainer = this.getEventQueue(partitionId);
            int drained = 0;
            drained += partitionWanEventContainer.drainMap(q -> true);
            partitionDrainsMap.put(partitionId, drained += partitionWanEventContainer.drainCache(q -> true));
        }
        return partitionDrainsMap;
    }

    public int drainMapQueuesMatchingPredicate(int partitionId, Predicate<WanEventQueue> predicate) {
        return this.getEventQueue(partitionId).drainMap(predicate);
    }

    public int drainCacheQueuesMatchingPredicate(int partitionId, Predicate<WanEventQueue> predicate) {
        return this.getEventQueue(partitionId).drainCache(predicate);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public PartitionWanEventContainer[] getContainers() {
        return this.containers;
    }

    public void clear() {
        for (PartitionWanEventContainer container : this.containers) {
            container.clear();
        }
    }

    public WanEventMigrationContainer prepareEventContainerReplicationData(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        PartitionWanEventContainer partitionContainer = this.getEventQueue(event.getPartitionId());
        if (partitionContainer != null) {
            PartitionWanEventQueueMap mapQueues = this.collectNamespaces(partitionContainer.getMapEventQueueMapByBackupCount(event.getReplicaIndex()), "hz:impl:mapService", namespaces);
            PartitionWanEventQueueMap cacheQueues = this.collectNamespaces(partitionContainer.getCacheEventQueueMapByBackupCount(event.getReplicaIndex()), "hz:impl:cacheService", namespaces);
            return new WanEventMigrationContainer(mapQueues, cacheQueues);
        }
        return null;
    }

    public void collectAllServiceNamespaces(PartitionReplicationEvent event, Set<ServiceNamespace> namespaces) {
        int partitionId = event.getPartitionId();
        PartitionWanEventContainer partitionContainer = this.getEventQueue(partitionId);
        if (partitionContainer == null) {
            return;
        }
        int replicaIndex = event.getReplicaIndex();
        PartitionWanEventQueueMap mapQueues = partitionContainer.getMapEventQueueMapByBackupCount(replicaIndex);
        PartitionWanEventQueueMap cacheQueues = partitionContainer.getCacheEventQueueMapByBackupCount(replicaIndex);
        for (String mapName : mapQueues.keySet()) {
            namespaces.add(MapService.getObjectNamespace(mapName));
        }
        for (String cacheName : cacheQueues.keySet()) {
            namespaces.add(CacheService.getObjectNamespace(cacheName));
        }
    }

    private PartitionWanEventQueueMap collectNamespaces(PartitionWanEventQueueMap queues, String serviceName, Collection<ServiceNamespace> namespaces) {
        if (queues.isEmpty()) {
            return null;
        }
        PartitionWanEventQueueMap filteredQueues = new PartitionWanEventQueueMap();
        for (ServiceNamespace namespace : namespaces) {
            ObjectNamespace ns;
            WanEventQueue q;
            if (!serviceName.equals(namespace.getServiceName()) || (q = (WanEventQueue)queues.get((ns = (ObjectNamespace)namespace).getObjectName())) == null) continue;
            filteredQueues.put(ns.getObjectName(), q);
        }
        return filteredQueues;
    }
}

