/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence.operation;

import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftSystemOperation;
import com.hazelcast.cp.internal.persistence.CPPersistenceDataSerializerHook;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class PublishRestoredCPMembersOp
extends Operation
implements IdentifiedDataSerializable,
RaftSystemOperation {
    private RaftGroupId metadataGroupId;
    private long membersCommitIndex;
    private Collection<CPMember> members;

    public PublishRestoredCPMembersOp() {
    }

    public PublishRestoredCPMembersOp(RaftGroupId metadataGroupId, long membersCommitIndex, Collection<CPMember> members) {
        this.metadataGroupId = metadataGroupId;
        this.membersCommitIndex = membersCommitIndex;
        this.members = members;
    }

    @Override
    public void run() {
        ILogger logger;
        RaftService service = (RaftService)this.getService();
        if (service.updateInvocationManagerMembers(this.metadataGroupId.getSeed(), this.membersCommitIndex, this.members) && (logger = this.getNodeEngine().getLogger(this.getClass())).isFineEnabled()) {
            logger.fine("Received restored seed: " + this.metadataGroupId.getSeed() + ", members commit index: " + this.membersCommitIndex + ", CP member list: " + this.members);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return CPPersistenceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.metadataGroupId);
        out.writeLong(this.membersCommitIndex);
        out.writeInt(this.members.size());
        for (CPMember member : this.members) {
            out.writeObject(member);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.metadataGroupId = (RaftGroupId)in.readObject();
        this.membersCommitIndex = in.readLong();
        int len = in.readInt();
        this.members = new ArrayList<CPMember>(len);
        for (int i = 0; i < len; ++i) {
            CPMemberInfo member = (CPMemberInfo)in.readObject();
            this.members.add(member);
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(", metadataGroupId=").append(this.metadataGroupId).append(", membersCommitIndex").append(this.membersCommitIndex).append(", members=").append(this.members);
    }
}

