/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.nativememory;

import com.hazelcast.cache.impl.CacheRSMutationObserver;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.wan.impl.merkletree.MerkleTree;

public class MerkleTreeRSMutationObserver
implements CacheRSMutationObserver {
    private final MerkleTree merkleTree;
    private final SerializationService serializationService;

    public MerkleTreeRSMutationObserver(MerkleTree merkleTree, SerializationService serializationService) {
        this.merkleTree = merkleTree;
        this.serializationService = serializationService;
    }

    @Override
    public void onCreate(Data key, Object value) {
        this.merkleTree.updateAdd(key, this.asData(value));
    }

    @Override
    public void onRemove(Data key, Object value) {
        this.merkleTree.updateRemove(key, this.asData(value));
    }

    @Override
    public void onUpdate(Data key, Object oldValue, Object value) {
        this.merkleTree.updateReplace(key, this.asData(oldValue), this.asData(value));
    }

    @Override
    public void onEvict(Data key, Object value) {
        this.merkleTree.updateRemove(key, this.asData(value));
    }

    @Override
    public void onExpire(Data key, Object value) {
        this.merkleTree.updateRemove(key, this.asData(value));
    }

    @Override
    public void onDestroy() {
        this.merkleTree.clear();
    }

    private Data asData(Object value) {
        return this.serializationService.toData(value);
    }
}

