/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.com.esri.core.geometry.Envelope;
import com.hazelcast.com.esri.core.geometry.Geometry;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.DataContext;
import com.hazelcast.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.runtime.GeoFunctions;
import com.hazelcast.org.apache.calcite.runtime.Geometries;
import com.hazelcast.org.apache.calcite.schema.ScannableTable;
import com.hazelcast.org.apache.calcite.schema.Schema;
import com.hazelcast.org.apache.calcite.schema.Statistic;
import com.hazelcast.org.apache.calcite.schema.Statistics;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.math.BigDecimal;

public class SqlGeoFunctions {
    private SqlGeoFunctions() {
    }

    public static ScannableTable ST_MakeGrid(Geometries.Geom geom, BigDecimal deltaX, BigDecimal deltaY) {
        return new GridTable(geom, deltaX, deltaY, false);
    }

    public static ScannableTable ST_MakeGridPoints(Geometries.Geom geom, BigDecimal deltaX, BigDecimal deltaY) {
        return new GridTable(geom, deltaX, deltaY, true);
    }

    public static class GridTable
    implements ScannableTable {
        private final Geometries.Geom geom;
        private final BigDecimal deltaX;
        private final BigDecimal deltaY;
        private boolean point;

        GridTable(Geometries.Geom geom, BigDecimal deltaX, BigDecimal deltaY, boolean point) {
            this.geom = geom;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.point = point;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("THE_GEOM", SqlTypeName.GEOMETRY).add("ID", SqlTypeName.INTEGER).add("ID_COL", SqlTypeName.INTEGER).add("ID_ROW", SqlTypeName.INTEGER).add("ABS_COL", SqlTypeName.INTEGER).add("ABS_ROW", SqlTypeName.INTEGER).build();
        }

        @Override
        public Enumerable<@Nullable Object[]> scan(DataContext root) {
            if (this.geom != null && this.deltaX != null && this.deltaY != null) {
                Geometry geometry = this.geom.g();
                Envelope envelope = new Envelope();
                geometry.queryEnvelope(envelope);
                if (this.deltaX.compareTo(BigDecimal.ZERO) > 0 && this.deltaY.compareTo(BigDecimal.ZERO) > 0) {
                    return new GeoFunctions.GridEnumerable(envelope, this.deltaX, this.deltaY, this.point);
                }
            }
            return Linq4j.emptyEnumerable();
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.of(100.0, ImmutableList.of(ImmutableBitSet.of(0, 1)));
        }

        @Override
        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.OTHER;
        }

        @Override
        public boolean isRolledUp(String column) {
            return false;
        }

        @Override
        public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, @Nullable SqlNode parent, @Nullable CalciteConnectionConfig config) {
            return false;
        }
    }
}

