/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.sql.SqlAggFunction;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.sql.validate.AggregatingSelectScope;
import com.hazelcast.org.apache.calcite.sql.validate.OrderByScope;
import com.hazelcast.org.apache.calcite.sql.validate.SelectScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.org.apache.calcite.util.Optionality;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlAbstractGroupFunction
extends SqlAggFunction {
    public SqlAbstractGroupFunction(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        super(name, null, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category, false, false, Optionality.FORBIDDEN);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(scope);
        assert (selectScope != null);
        SqlSelect select = selectScope.getNode();
        if (!validator.isAggregate(select)) {
            throw validator.newValidationError(call, Static.RESOURCE.groupingInAggregate(this.getName()));
        }
        AggregatingSelectScope aggregatingSelectScope = SqlValidatorUtil.getEnclosingAggregateSelectScope(scope);
        if (aggregatingSelectScope == null) {
            throw validator.newValidationError(call, Static.RESOURCE.groupingInWrongClause(this.getName()));
        }
        for (SqlNode operand : call.getOperandList()) {
            operand = scope instanceof OrderByScope ? validator.expandOrderExpr(select, operand) : validator.expand(operand, scope);
            if (aggregatingSelectScope.resolved.get().isGroupingExpr(operand)) continue;
            throw validator.newValidationError(operand, Static.RESOURCE.groupingArgument(this.getName()));
        }
    }

    @Override
    public boolean isQuantifierAllowed() {
        return false;
    }

    @Override
    public boolean allowsFilter() {
        return false;
    }
}

