/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.com.google.common.base.Preconditions;
import com.hazelcast.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.TimestampString;
import java.util.Objects;

public class SqlTimestampLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimestampLiteral(TimestampString ts, int precision, boolean hasTimeZone, SqlParserPos pos) {
        super(ts, hasTimeZone, SqlTypeName.TIMESTAMP, precision, pos);
        Preconditions.checkArgument(this.precision >= 0);
    }

    @Override
    public SqlTimestampLiteral clone(SqlParserPos pos) {
        return new SqlTimestampLiteral((TimestampString)Objects.requireNonNull(this.value, "value"), this.precision, this.hasTimeZone, pos);
    }

    @Override
    public String toString() {
        return "TIMESTAMP '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        TimestampString ts = this.getTimestamp();
        if (this.precision > 0) {
            ts = ts.round(this.precision);
        }
        return ts.toString(this.precision);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.getDialect().unparseDateTimeLiteral(writer, this, leftPrec, rightPrec);
    }
}

