/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.schema.impl;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.org.apache.calcite.materialize.Lattice;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.schema.Schema;
import com.hazelcast.org.apache.calcite.schema.Table;
import com.hazelcast.org.apache.calcite.schema.TranslatableTable;
import com.hazelcast.org.apache.calcite.schema.impl.AbstractTable;
import com.hazelcast.org.apache.calcite.util.ImmutableIntList;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StarTable
extends AbstractTable
implements TranslatableTable {
    public final Lattice lattice;
    public final ImmutableList<Table> tables;
    public @MonotonicNonNull ImmutableIntList fieldCounts;

    private StarTable(Lattice lattice, ImmutableList<Table> tables) {
        this.lattice = Objects.requireNonNull(lattice, "lattice");
        this.tables = tables;
    }

    public static StarTable of(Lattice lattice, List<Table> tables) {
        return new StarTable(lattice, ImmutableList.copyOf(tables));
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.STAR;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        ArrayList<Integer> fieldCounts = new ArrayList<Integer>();
        for (Table table : this.tables) {
            RelDataType rowType = table.getRowType(typeFactory);
            typeList.addAll(RelOptUtil.getFieldTypeList(rowType));
            fieldCounts.add(rowType.getFieldCount());
        }
        if (this.fieldCounts == null) {
            this.fieldCounts = ImmutableIntList.copyOf(fieldCounts);
        }
        return typeFactory.createStructType(typeList, this.lattice.uniqueColumnNames());
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        return new StarTableScan(context.getCluster(), table);
    }

    public StarTable add(Table table) {
        return StarTable.of(this.lattice, (List<Table>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.tables)).add(table)).build()));
    }

    public int columnOffset(Table table) {
        int n = 0;
        for (Pair pair : Pair.zip(this.tables, Nullness.castNonNull(this.fieldCounts))) {
            if (pair.left == table) {
                return n;
            }
            n += ((Integer)pair.right).intValue();
        }
        throw new IllegalArgumentException("star table " + this + " does not contain table " + table);
    }

    public static class StarTableScan
    extends TableScan {
        public StarTableScan(RelOptCluster cluster, RelOptTable relOptTable) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), ImmutableList.of(), relOptTable);
        }

        @Override
        public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeInfiniteCost();
        }
    }
}

