/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.connector.WriteJdbcP;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJdbcSqlConnectorProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.security.permission.ConnectorPermission;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.CommonDataSource;

public class InsertProcessorSupplier
extends AbstractJdbcSqlConnectorProcessorSupplier
implements DataSerializable,
SecuredFunction {
    private String query;
    private int batchLimit;

    public InsertProcessorSupplier() {
    }

    public InsertProcessorSupplier(String externalDataStoreRef, String query, int batchLimit) {
        super(externalDataStoreRef);
        this.query = query;
        this.batchLimit = batchLimit;
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<WriteJdbcP> processors = new ArrayList<WriteJdbcP>(count);
        for (int i = 0; i < count; ++i) {
            WriteJdbcP processor = new WriteJdbcP(this.query, (CommonDataSource)this.dataSource, (BiConsumerEx & Serializable)(ps, row) -> {
                for (int j = 0; j < row.getFieldCount(); ++j) {
                    ps.setObject(j + 1, row.get(j));
                }
            }, this::isNonTransientException, false, this.batchLimit);
            processors.add(processor);
        }
        return processors;
    }

    private boolean isNonTransientException(SQLException e) {
        SQLException next = e.getNextException();
        return e instanceof SQLNonTransientException || e.getCause() instanceof SQLNonTransientException || !this.isTransientCode(e.getSQLState()) || next != null && e != next && this.isNonTransientException(next);
    }

    private boolean isTransientCode(String code) {
        switch (code) {
            case "08000": 
            case "08001": 
            case "08003": 
            case "08004": 
            case "08006": 
            case "08007": 
            case "40001": 
            case "40P01": 
            case "53000": 
            case "53100": 
            case "53200": 
            case "53300": 
            case "53400": 
            case "55000": 
            case "55006": 
            case "55P03": 
            case "57P03": 
            case "58000": 
            case "58030": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public List<Permission> permissions() {
        return Collections.singletonList(ConnectorPermission.jdbc((String)this.externalDataStoreRef, (String)"write"));
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.externalDataStoreRef);
        out.writeString(this.query);
        out.writeInt(this.batchLimit);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.externalDataStoreRef = in.readString();
        this.query = in.readString();
        this.batchLimit = in.readInt();
    }
}

